% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscfuns.R
\docType{data}
\name{setFplot_dict}
\alias{setFplot_dict}
\alias{getFplot_dict}
\title{Sets/gets the dictionary used in \code{fplot}}
\format{
An object of class \code{function} of length 1.
}
\usage{
setFplot_dict(dict)

getFplot_dict
}
\arguments{
\item{dict}{A named character vector. E.g. to change my variable named "us_md" and "state" to (resp.) "$ miilion" and "U.S. state", then use \code{dict = c(us_md="$ million", state = "U.S. state")}.}
}
\description{
Sets/gets the default dictionary used to rename the axes/moderator variables in the functions of the package \code{fplot}. The dictionaries are used to relabel variables (usually towards a fancier, more explicit formatting) that can be useful not to explicitly use the arguments xlab/ylab when exporting graphs. By setting the dictionary with \code{setFplot_dict}, you can avoid providing the argument \code{dict} in \code{fplot} functions.
}
\examples{

data(airquality)
setFplot_dict(c(Ozone = "Ozone (ppb)"))
plot_distr(Ozone ~ Month, airquality, weight.fun = mean)

}
\author{
Laurent Berge
}
\keyword{datasets}
