% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tostring.R
\name{padstr}
\alias{padstr}
\title{Pad a string and align within string}
\usage{
padstr(x, n, just = list_valid_aligns())
}
\arguments{
\item{x}{(\code{string})\cr a string.}

\item{n}{(\code{integer(1)})\cr number of characters in the output string. If \code{n < nchar(x)}, an error is thrown.}

\item{just}{(\code{string})\cr text alignment justification to use. Defaults to \code{"center"}. Must be one of
\code{"center"}, \code{"right"}, \code{"left"}, \code{"dec_right"}, \code{"dec_left"}, or \code{"decimal"}.}
}
\value{
\code{x}, padded to be a string of length \code{n}.
}
\description{
Pad a string and align within string
}
\examples{
padstr("abc", 3)
padstr("abc", 4)
padstr("abc", 5)
padstr("abc", 5, "left")
padstr("abc", 5, "right")

\dontrun{
# Expect error: "abc" has more than 1 characters
padstr("abc", 1)
}

}
