% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idio.R
\name{print.threshold}
\alias{print.threshold}
\title{Print threshold}
\usage{
\method{print}{threshold}(x, ...)
}
\arguments{
\item{x}{\code{threshold} object}

\item{...}{not used}
}
\value{
NULL, printed to console
}
\description{
Prints a summary of a \code{threshold} object
}
\examples{
\dontrun{
library(fnets)
out <- fnets(data.unrestricted,
   var.args = list(n.cores = 2)
)
# Granger-causal network
th1 <- threshold(out$idio.var$beta)
plot(th1)
print(th1)
# Partial correlations
th2 <- threshold(out$lrpc$pc)
# Long-run partial correlations
th3 <- threshold(out$lrpc$lrpc)
}
}
\seealso{
\link[fnets]{threshold}
}
