% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0S4.R
\docType{class}
\name{fmx-class}
\alias{fmx-class}
\title{\linkS4class{fmx} Class: Finite Mixture Parametrization}
\description{
An S4 object to specify
the parameters and type of distribution
of a one-dimensional finite mixture distribution.
}
\section{Slots}{

\describe{
\item{\code{distname}}{\link[base]{character} scalar,
name of parametric distribution of the mixture components.
Currently, normal (\code{'norm'}) and Tukey \eqn{g}-&-\eqn{h} (\code{'GH'}) distributions are supported.}

\item{\code{pars}}{\link[base]{double} \link[base]{matrix},
all distribution parameters in the mixture.
Each row corresponds to one component. Each column includes the same parameters of all components.
The order of rows corresponds to the (non-strictly) increasing order of the component location parameters.
The columns match the formal arguments of the corresponding distribution,
e.g., \code{'mean'} and \code{'sd'} for \link[stats:dnorm]{normal} mixture,
or \code{'A'}, \code{'B'}, \code{'g'} and \code{'h'} for Tukey \eqn{g}-&-\eqn{h} mixture.}

\item{\code{w}}{\link[base]{numeric} \link[base]{vector} of mixing proportions that must sum to 1}

\item{\code{data}}{(optional) \link[base]{numeric} \link[base]{vector}, the one-dimensional observations}

\item{\code{data.name}}{(optional) \link[base]{character} scalar, a human-friendly name of the observations}

\item{\code{epdf}}{(optional) empirical probability density \link[base]{function} returned by \link[stats]{approxfun}}

\item{\code{vcov_internal}}{(optional) variance-covariance \link[base]{matrix} of the internal (i.e., unconstrained) estimates}

\item{\code{vcov}}{(optional) variance-covariance \link[base]{matrix} of the mixture distribution (i.e., constrained) estimates}

\item{\code{Kolmogorov,CramerVonMises,KullbackLeibler}}{(optional) \link[base]{numeric} scalars}
}}

