% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{plot_globeproj}
\alias{plot_globeproj}
\title{Plot a globeproj object}
\usage{
plot_globeproj(
  x,
  xlim = NULL,
  ylim = NULL,
  outline = TRUE,
  graticule = c(24, 12),
  tissot = c(12, 6),
  asp = 1,
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{A \link{globeproj} object}

\item{xlim, ylim}{The x- and y-axis limits}

\item{outline}{logical}

\item{graticule}{The number of graticules (n-long, n-lat) to compute}

\item{tissot}{The number of Tissot indicatrices (n-long, n-lat) to compute}

\item{asp}{the aspect ratio. Default = 1}

\item{add}{logical; If \code{TRUE}, add to existing plot. Default: \code{FALSE}}

\item{\dots}{Additional parameters passed on to other methods}
}
\value{
Nothing
}
\description{
Plot a globeproj object
}
\examples{
proj <- old_globeproj("moll", orient = c(0, 0, 45))
plot_globeproj(proj, graticule = c(24, 12), add = FALSE, asp = 1, lty = 2, lwd = 0.5)
}
\author{
Finn Lindgren
}
