% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline.R
\name{basis}
\alias{basis}
\alias{dbasis}
\alias{fss}
\alias{dfss}
\title{Natural cubic spline basis}
\usage{
basis(knots, x, spline = "rp")
}
\arguments{
\item{knots}{Vector of knot locations in increasing order, including the
boundary knots at the beginning and end.}

\item{x}{Vector of ordinates to compute the basis for.}

\item{spline}{\code{"rp"} to use the natural cubic spline basis
described in Royston and Parmar.  \code{"splines2ns"} to use the
alternative natural cubic spline basis from the \code{splines2}
package (Wang and Yan 2021), which may be better behaved due to
the basis being orthogonal.}
}
\value{
A matrix with one row for each ordinate and one column for each
knot.

\code{basis} returns the basis, and \code{dbasis} returns its derivative
with respect to \code{x}.

\code{fss} and \code{dfss} are the same, but with the order of the
arguments swapped around for consistency with similar functions in other R
packages.
}
\description{
Compute a basis for a natural cubic spline, by default using the
parameterisation described by Royston and Parmar (2002).  Used for
flexible parametric survival models.
}
\details{
The exact formula for the basis is given in \code{\link{flexsurvspline}}.
}
\references{
Royston, P. and Parmar, M. (2002).  Flexible parametric
proportional-hazards and proportional-odds models for censored survival
data, with application to prognostic modelling and estimation of treatment
effects. Statistics in Medicine 21(1):2175-2197.

Wang W, Yan J (2021). Shape-Restricted Regression Splines with R
Package splines2. Journal of Data Science, 19(3), 498-517.
}
\seealso{
\code{\link{flexsurvspline}}.
}
\author{
Christopher Jackson <chris.jackson@mrc-bsu.cam.ac.uk>
}
\keyword{models}
