% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pibble_plotting.R
\name{plot.pibblefit}
\alias{plot.pibblefit}
\title{Plot Summaries of Posterior Distribution of pibblefit Parameters}
\usage{
\method{plot}{pibblefit}(x, ...)
}
\arguments{
\item{x}{an object of class pibblefit}

\item{...}{other arguments passed to plot.pibblefit (see details)}
}
\value{
ggplot object
}
\description{
Plot Summaries of Posterior Distribution of pibblefit Parameters
}
\details{
Other arguments:
\itemize{
\item `par` parameter to plot (options: Lambda, Eta, and Sigma) 
  (default="Lambda")
\item `focus.cov` vector of covariates to include in plot (plots all if NULL)
\item `focus.coord` vector of coordinates to include in plot (plots all if NULL)
\item `focus.sample` vector of samples to include in plot (plots all if NULL)
\item `use_names` if TRUE, uses dimension names found in data as plot labels
  rather than using dimension integer indices. 
}
}
\examples{
sim <- pibble_sim(N=10, D=4, Q=3)
fit <- pibble(sim$Y, sim$X)
plot(fit, par="Lambda")
plot(fit, par="Sigma")
}
