% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodNAF.R
\name{nonadaptivefence}
\alias{nonadaptivefence}
\title{Nonadaptive Fence model selection}
\usage{
nonadaptivefence(mf, f, ms, d, lf, pf, cn)
}
\arguments{
\item{mf}{function for fitting the model}

\item{f}{formula of full model}

\item{ms}{list of formula of candidates models}

\item{d}{data}

\item{lf}{measure lack of fit (to minimize)}

\item{pf}{model selection criteria, e.g., model dimension}

\item{cn}{given a specific c value}
}
\value{
\item{models}{list all model candidates in the model space}
\item{lack_of_fit}{list a vector of Qs for all model candidates}
\item{formula}{list the model of the selected parsimonious model}
\item{sel_model}{list the selected (parsimonious) model given the adaptive c value}
}
\description{
Nonadaptive Fence model selection
}
\examples{
\dontrun{
require(fence)

#### Example 1 #####
data(iris)
full = Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width + (1|Species)
test_naf = fence.lmer(full, iris, fence = "nonadaptive", cn = 12)
test_naf$sel_model
}
}
\references{
\itemize{
 \item{Jiang J., Rao J.S., Gu Z., Nguyen T. (2008),  Fence Methods for Mixed Model Selection. The Annals of Statistics, 36(4): 1669-1692}
 \item{Jiang J., Nguyen T., Rao J.S. (2009), A Simplified Adaptive Fence Procedure. Statistics and Probability Letters, 79, 625-629}
 \item{Thuan Nguyen, Jie Peng, Jiming Jiang (2014), Fence Methods for Backcross Experiments.  Statistical Computation and Simulation, 84(3), 644-662}
}
}
\author{
Jiming Jiang  Jianyang Zhao  J. Sunil Rao  Thuan Nguyen
}
