% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence.fregre.fd.R
\name{influence.fregre.fd}
\alias{influence.fregre.fd}
\title{Functional influence measures}
\usage{
\method{influence}{fregre.fd}(model, ...)
}
\arguments{
\item{model}{\code{fregre.pc}, \code{fregre.basis} or \code{fregre.basis.cv} object.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Return:
\itemize{
 \item \code{DCP}{ Cook's Distance for Prediction.}
 \item \code{DCE}{ Cook's Distance for Estimation.}
 \item \code{DP}{ \eqn{\mbox{Pe}\tilde{\mbox{n}}\mbox{a's} }{} Distance.}
 }
}
\description{
Once estimated the functional regression model with scalar response,
influence.fregre.fd function is used to obtain the functional influence measures.
}
\details{
Identify influential observations in the functional linear model in which 
the predictor is functional and the response is scalar.
Three statistics are introduced for measuring the influence:   Distance Cook Prediction
 \code{DCP}, Distance Cook Estimation \code{DCE} and Distance
  \eqn{\mbox{pe}\tilde{\mbox{n}}\mbox{a} }{} \code{DP} respectively.
}
\note{
influence.fdata deprecated.
}
\examples{
\dontrun{
data(tecator)
x=tecator$absorp.fdata[1:129]
y=tecator$y$Fat[1:129]

res1=fregre.pc(x,y,1:5)  
# time consuming
res.infl1=influence(res1)  
res2=fregre.basis(x,y)  
res.infl2=influence(res2)  

res<-res1
res.infl<-res.infl1
mat=cbind(y,res$fitted.values,res.infl$DCP,res.infl$DCE,res.infl$DP)
colnames(mat)=c("Resp.","Pred.","DCP","DCE","DP")
pairs(mat)
}
}
\references{
Febrero-Bande, M., Galeano, P. and Gonzalez-Manteiga, W. (2010). \emph{Measures of influence for the functional linear model with scalar response}. Journal of Multivariate Analysis 101, 327-339.

Febrero-Bande,  M., Oviedo de la Fuente, M. (2012).  \emph{Statistical Computing in Functional Data Analysis: The R Package fda.usc.}
Journal of Statistical Software, 51(4), 1-28. \url{https://www.jstatsoft.org/v51/i04/}
}
\seealso{
See Also as:  \code{\link{fregre.pc}}, \code{\link{fregre.basis}}, 
 \code{\link{influence_quan}}
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente \email{manuel.oviedo@udc.es}
}
\keyword{outliers}
