% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd_lasso}
\alias{fastcpd_lasso}
\alias{fastcpd.lasso}
\title{Find change points efficiently in penalized linear regression models}
\usage{
fastcpd_lasso(data, ...)

fastcpd.lasso(data, ...)
}
\arguments{
\item{data}{A matrix or a data frame with the response variable as the first
column.}

\item{...}{Other arguments passed to \code{\link[=fastcpd]{fastcpd()}}, for example,
\code{segment_count}.}
}
\value{
A \linkS4class{fastcpd} object.
}
\description{
\code{\link[=fastcpd_lasso]{fastcpd_lasso()}} and \code{\link[=fastcpd.lasso]{fastcpd.lasso()}} are wrapper
functions of \code{\link[=fastcpd]{fastcpd()}} to find change points in penalized
linear regression models. The function is similar to \code{\link[=fastcpd]{fastcpd()}}
except that the data is by default a matrix or data frame with the response
variable as the first column and thus a formula is not required here.
}
\examples{
\donttest{
set.seed(1)
n <- 480
p_true <- 5
p <- 50
x <- mvtnorm::rmvnorm(n, rep(0, p), diag(p))
theta_0 <- rbind(
  runif(p_true, -5, -2),
  runif(p_true, -3, 3),
  runif(p_true, 2, 5),
  runif(p_true, -5, 5)
)
theta_0 <- cbind(theta_0, matrix(0, ncol = p - p_true, nrow = 4))
y <- c(
  x[1:80, ] \%*\% theta_0[1, ] + rnorm(80, 0, 1),
  x[81:200, ] \%*\% theta_0[2, ] + rnorm(120, 0, 1),
  x[201:320, ] \%*\% theta_0[3, ] + rnorm(120, 0, 1),
  x[321:n, ] \%*\% theta_0[4, ] + rnorm(160, 0, 1)
)
result <- fastcpd.lasso(
  cbind(y, x),
  multiple_epochs = function(segment_length) if (segment_length < 30) 1 else 0
)
summary(result)
plot(result)

thetas <- result@thetas
thetas <- cbind.data.frame(thetas, t(theta_0))
names(thetas) <- c(
  "segment 1", "segment 2", "segment 3", "segment 4",
  "segment 1 truth", "segment 2 truth", "segment 3 truth", "segment 4 truth"
)
thetas$coordinate <- c(seq_len(p_true), rep("rest", p - p_true))
molten <- reshape2::melt(thetas, id.vars = "coordinate")
molten <- dplyr::mutate(
  molten,
  segment = gsub("segment ", "", variable),
  segment = gsub(" truth", "", segment),
  height = as.numeric(gsub("segment.*", "", segment)) +
    0.2 * as.numeric(grepl("truth", variable)),
  parameter = ifelse(grepl("truth", variable), "truth", "estimated")
)
ggplot2::ggplot() +
  ggplot2::geom_point(
    data = molten,
    ggplot2::aes(x = value, y = height, shape = coordinate, color = parameter),
    size = 4
  ) +
  ggplot2::ylim(0.8, 4.4) +
  ggplot2::ylab("segment") +
  ggplot2::theme_bw()
}
}
\seealso{
\code{\link[=fastcpd]{fastcpd()}}
}
