% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fastcmh.R
\name{runfastcmh}
\alias{runfastcmh}
\title{Run the fastcmh algorithm}
\usage{
runfastcmh(folder = NULL, data = NULL, label = NULL, cov = NULL,
  alpha = 0.05, Lmax = 0, showProcessing = FALSE, saveAllPvals = FALSE,
  doFDR = FALSE, useDependenceFDR = FALSE, saveToFile = FALSE,
  saveFilename = "fastcmhresults.RData", saveFolder = NULL)
}
\arguments{
\item{folder}{The folder in which the data is saved. If the any of
\code{data}, \code{label} and \code{pvalue} arguments are not specified,
then filenames must have following a naming convention inside the folder:
the data file is \code{"data.txt"}
(i.e. the full path is \code{"folder/data.txt"}), the phenotype label file
is \code{label.txt}, and covariate label file is
\code{cov.txt}. More details on the structure of these files is given
below, or the user can use the \code{\link{makefastcmhdata}} function to
see an example of the correct data formats. If \code{folder="/data/"}, the
data in \code{fastcmh/inst/extdata} is used.}

\item{data}{The filename for the data file. Default is \code{NULL}. The
data file must be an \code{L x n} txt file containing only \code{0}s and
\code{1}s, which are space-separated in each row, while each row is on a
separate newline.}

\item{label}{The filename for the phenotype label file. Default is
\code{NULL}. The label file should consist of a single column (i.e. each
row is on a separate line) of \code{0}s and \code{1}s.}

\item{cov}{The filename for the covariate label file. Default is
\code{NULL}. The \code{cov} file contains a single column of positive
integers. The first row, containing value \eqn{n_1}, specifies that the
first \eqn{n_1} columns have covariate value \code{1}; the second row,
containing \eqn{n_2}, specifies that the next \eqn{n_2} rows have
covariate value \code{2}, etc.}

\item{alpha}{The value of the FWER; must be a number between 0 and 1.
Default is \code{alpha=0.05}.}

\item{Lmax}{The maximum length of significant intervals which is
considered. Must be a non-negative integer. For example, \code{Lmax=10}
searches for significant intervals up to length 10. Setting \code{Lmax=0}
will search for significant intervals up to any length (with algorithm
pruning appropriately). Default is \code{Lmax=0}.}

\item{showProcessing}{A flag which will turn printing to screen on/off.
Default is \code{FALSE} (which is \dQuote{off}).}

\item{saveAllPvals}{A flag which controls whether or not all the intervals
(less than minimum attainable pvalue) will be returned. Default is
\code{FALSE} (which is \dQuote{no, do notreturn all intervals}).}

\item{doFDR}{A flag which controls whether or not Gilbert's Tarone FDR
procedure (while accounting for positive regression dependence) is
performed. Default is \code{FALSE} (which is \dQuote{no, do not do FDR}).}

\item{useDependenceFDR}{A flag which controls whether or not Gilbert's
Tarone FDR procedure uses the dependent formulation by Benjamini and
Yekutieli (2001), which further adjusts alpha by dividing by the harmonic
mean. This flag is only used if \code{doFDR==TRUE}. Default is \code{FALSE}.}

\item{saveToFile}{A flag which controls whether or not the results are
saved to file. By default, \code{saveToFile=FALSE}, and the data frame is
returned in R. See the examples below.}

\item{saveFilename}{A string which gives the filename to which the output
is saved (needs to have \code{saveToFile=TRUE}) as an RData file. Default
is \code{"fastcmhresults.RData"}.}

\item{saveFolder}{A string which gives the path to which the output will
be saved (needs to have \code{saveToFile=TRUE}). Default is \code{"./"}.}
}
\description{
This function runs the FastCMH algorithm on a particular data set.
}
\section{Details}{

This function runs the FastCMH algorithm on a particular data set in
order to discover intervals that are statistically significantly
associated with a particular label, while accounting for categorical
covariates.

The user must either supply the folder, which contains files named
\code{"data.txt"}, \code{"label.txt"} and \code{"cov.txt"}, or the
non-default filenames must be specified individually. See the descriptions of arguments \code{data}, \code{label} and \code{cov} to see the format of
the input files, or make a small sample data file using the
\code{\link{makefastcmhdata}} function.
By default, filtered results are provided. The user also has the option
of using an FDR procedure rather than the standard FWER-preserving
procedure.
}

\section{Value}{

\code{runfastcmh} will return a list if \code{saveToFile=FALSE} (default
setting), otherwise it will save the list in an .RData file. The fields
of the list are:

\describe{
\item{\code{sig}}{a dataframe listing the significant intervals, after
filterting. Columns \code{start}, \code{end} and \code{pvalue} indicate
the start and end points of the interval (inclusive), and the
\emph{p}-value for that interval.}

\item{\code{unfiltered}}{a dataframe listing all the significant intervals
before filtering. The filtering compares the overlapping intervals and
returns the interval with the smallest p-value in each cluster of
overlapping intervals. Dataframe has has structure as \code{sig}.}

\item{\code{fdr}}{(if doFDR==TRUE) significant intervals using Gilbert's
FDR-Tarone procedure, after filtering. Dataframe has same structure as
\code{sig}.}

\item{\code{unfilteredFdr}}{(if doFDR==TRUE) a dataframe listing all the significant intervals before filtering. See description of \code{unfiltered}.}

\item{\code{allTestablle}}{(if saveAllPvals==TRUE) a dataframe listing all
the testable intervals, many of which will not be significant. Dataframe
has same structure as \code{sig}.}

\item{\code{histObs}}{Together with histFreq gives a histogram of maximum
attainable CMH statistics.}

\item{\code{histFreq}}{Histogram of maximum attainable CMH statistics (only
reliable in the testable range).}

\item{\code{summary}}{a character string summarising the results. Use
\code{cat(...$summary)} to print the results with the correct
indentation/new lines.}

\item{\code{timing}}{a list containing (i) \code{details}, a character
string summarising the runtime values for the experiment - use
\code{cat(...$timing$details)} for correct indentation, etc.
(ii) \code{exec}, the total execution time. (iii) \code{init}, the time
to initialise the objects. (iv) \code{fileIO}, the time to read the input
files. (v) \code{compSigThresh}, the time to compute the significance
threshold. (vi) \code{compSigInt}, the time to compute the significant
intervals.}
}
}

\section{Author(s)}{

Felipe Llinares Lopez, Dean Bodenham
}

\section{See Also}{

\code{\link{makefastcmhdata}}
}

\section{References}{


Gilbert, P. B. (2005) \emph{A modified false discovery rate
multipl-comparisons procedure for discrete data, applied to human
immunodeficiency virus genetics}. Journal of the Royal Statistical
Society: Series C (Applied Statistics), 54(1), 143-158.

Benjamini, Y., Yekutieli, D. (2001). \emph{The control of the false
discovery rate in multiple testing under dependency}.
Annals of Statistics, 29(4), 1165-1188.
}
\examples{
#Example with default naming convention used for data, label and cov files
# Note: using "/data/" as the argument for folder
#       accesses the data/ directory in the fastcmh package folder
mylist <- runfastcmh("/data/")

#Example where the progress will be shown
mylist <- runfastcmh(folder="/data/", showProcessing=TRUE)

#Example where many parameters are specified
mylist <- runfastcmh(folder="/data/", data="data2.txt", alpha=0.01, Lmax=7)

#Example where Gilbert's Tarone-FDR procedure is used
mylist <- runfastcmh("/data/", doFDR=TRUE)

#Example where FDR procedure takes some dependence structures into account
mylist <- runfastcmh("/data/", doFDR=TRUE, useDependenceFDR=TRUE)
}

