% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{voltimeplot}
\alias{voltimeplot}
\title{Plot series-specific volatilities over time.}
\usage{
voltimeplot(x, these = seq_len(nrow(x$y)), legend = "topright", ...)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{these}{Index vector containing the time points to plot. Defaults
to \code{seq_len(nrow(x$y))}, i.e., all timepoints.}

\item{legend}{Where to position the \code{\link{legend}}.
If set to NULL, labels will be put directly next to the series.
Defaults to "topright".}

\item{...}{Additional parameters will be passed on to \code{\link{ts.plot}}.}
}
\value{
Returns \code{x} invisibly.
}
\description{
\code{voltimeplot} plots the marginal volatilities over time, i.e. the
series-specific conditional standard deviations. If these haven't been
stored during sampling (because \code{runningstore} has been set too low),
\code{voltimeplot} throws a warning.
}
\seealso{
Other plotting: 
\code{\link{comtimeplot}()},
\code{\link{corimageplot}()},
\code{\link{corplot}()},
\code{\link{cortimeplot}()},
\code{\link{evdiag}()},
\code{\link{facloadcredplot}()},
\code{\link{facloaddensplot}()},
\code{\link{facloadpairplot}()},
\code{\link{facloadpointplot}()},
\code{\link{facloadtraceplot}()},
\code{\link{logvartimeplot}()},
\code{\link{paratraceplot}()},
\code{\link{plot.fsvdraws}()},
\code{\link{plotalot}()}
}
\concept{plotting}
