% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsPlotMP.R
\name{tsPlotMP}
\alias{tsPlotMP}
\title{Time Series Plots}
\usage{
tsPlotMP(
  ret,
  add.grid = FALSE,
  layout = NULL,
  type = "l",
  yname = "RETURNS (\%)",
  Pct = FALSE,
  scaleType = "free",
  stripLeft = TRUE,
  main = NULL,
  lwd = 1,
  stripText.cex = 1,
  axis.cex = 1,
  color = "black",
  zeroLine = TRUE,
  panel = NULL
)
}
\arguments{
\item{ret}{an time series exposure/return object}

\item{add.grid}{logical variable.If 'TRUE', type = c('l', 'g'); If 'FALSE', type = c('l')}

\item{layout}{layout is a numeric vector of length 2 or 3 giving the number of columns, rows, and pages (optional) in a multipanel display.}

\item{type}{character. type of the plot; 'l' denotes a line, 'p' denotes a point, and 'b' and 'o' both denote both together.deafault is 'l'.}

\item{yname}{character or expression giving label(s) for the y-axis}

\item{Pct}{Pct controls if use the percentage value.}

\item{scaleType}{scaleType controls if use a same scale of y-axis, choose from c('same', 'free')}

\item{stripLeft}{logical variable to choose the position of strip, 'TRUE' for drawing strips on the left of each panel, 'FALSE' for drawing strips on the top of each panel}

\item{main}{Typically a character string or expression describing the main title.}

\item{lwd}{The line width, a positive number, defaulting to 1}

\item{stripText.cex}{a number indicating the amount by which strip text in the plot(s) should be scaled relative to the default. 1=default, 1.5 is 50\% larger, 0.5 is 50\% smaller, etc.}

\item{axis.cex}{a number indicating the amount by which axis in the plot(s) should be scaled relative to the default. 1=default, 1.5 is 50\% larger, 0.5 is 50\% smaller, etc.}

\item{color}{A specification for the default plotting color. Default is black.}

\item{zeroLine}{logical varible to choose add a dotted horizontal line at the zero vertical distance}

\item{panel}{function to add customized lines to the lattice plot. See examples.}
}
\value{
{No return value, called for plotting}
}
\description{
Plot time series with specific plotting parameters
}
\author{
Douglas Martin, Lingjie Yi
}
