% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repRisk.R
\name{repRisk}
\alias{repRisk}
\alias{repRisk.ffm}
\title{Decompose portfolio risk into individual factor contributions and provide tabular report}
\usage{
repRisk(object, ...)

\method{repRisk}{ffm}(
  object,
  weights = NULL,
  risk = c("Sd", "VaR", "ES"),
  decomp = c("FMCR", "FCR", "FPCR"),
  digits = NULL,
  invert = FALSE,
  nrowPrint = 20,
  p = 0.05,
  type = c("np", "normal"),
  sliceby = c("factor", "asset", "riskType"),
  isPrint = TRUE,
  isPlot = FALSE,
  layout = NULL,
  stripText.cex = 1,
  axis.cex = 1,
  portfolio.only = FALSE,
  ...
)
}
\arguments{
\item{object}{fit object of class \code{tsfm}, or \code{ffm}.}

\item{...}{other optional arguments passed to \code{\link[stats]{quantile}} and 
optional arguments passed to \code{\link[stats]{cov}}}

\item{weights}{a vector of weights of the assets in the portfolio, names of 
the vector should match with asset names. Default is NULL, in which case an 
equal weights will be used.}

\item{risk}{one of 'Sd' (standard deviation), 'VaR' (Value-at-Risk) or 'ES' (Expected Tail 
Loss or Expected Shortfall for calculating risk decompositon. Default is 'Sd'}

\item{decomp}{one of 'FMCR' (factor marginal contribution to risk), 
'FCR' 'factor contribution to risk' or 'FPCR' (factor percent contribution to risk).}

\item{digits}{digits of number in the resulting table. Default is NULL, in which case digtis = 3 will be
used for decomp = ( 'FMCR', 'FCR'), digits = 1 will be used for decomp = 'FPCR'. Used only when 
isPrint = 'TRUE'}

\item{invert}{a logical variable to change VaR/ES to positive number, default
is False and will return positive values.}

\item{nrowPrint}{a numerical value deciding number of assets/portfolio in result vector/table to print
or plot}

\item{p}{tail probability for calculation. Default is 0.05.}

\item{type}{one of "np" (non-parametric) or "normal" for calculating VaR & Es. 
Default is "np".}

\item{sliceby}{one of 'factor' (slice/condition by factor) or 'asset' (slice/condition by asset) or 'riskType'
Used only when isPlot = 'TRUE'}

\item{isPrint}{logical variable to print numeric output or not.}

\item{isPlot}{logical variable to generate plot or not.}

\item{layout}{layout is a numeric vector of length 2 or 3 giving the number of columns, rows, and pages (optional) in a multipanel display.}

\item{stripText.cex}{a number indicating the amount by which strip text in the plot(s) should be scaled relative to the default. 1=default, 1.5 is 50\% larger, 0.5 is 50\% smaller, etc.}

\item{axis.cex}{a number indicating the amount by which axis in the plot(s) should be scaled relative to the default. 1=default, 1.5 is 50\% larger, 0.5 is 50\% smaller, etc.}

\item{portfolio.only}{logical variable to choose if to calculate portfolio only decomposition, in which case multiple risk measures are 
allowed.}
}
\value{
A table containing 
\item{decomp = 'FMCR'}{(N + 1) * (K + 1) matrix of marginal contributions to risk of portfolio 
return as well assets return, with first row of values for the portfolio and the remaining rows for 
the assets in the portfolio, with  (K + 1) columns containing values for the K risk factors and the
residual respectively}
\item{decomp = 'FCR'}{(N + 1) * (K + 2) matrix of component contributions to risk of portfolio 
return as well assets return, with first row of values for the portfolio and the remaining rows for 
the assets in the portfolio, with  first column containing portfolio and asset risk values and remaining
(K + 1) columns containing values for the K risk factors and the residual respectively}
\item{decomp = 'FPCR'}{(N + 1) * (K + 1) matrix of percentage component contributions to risk 
of portfolio return as well assets return, with first row of values for the portfolio and the remaining rows for 
the assets in the portfolio, with  (K + 1) columns containing values for the K risk factors and the
residual respectively}
Where, K is the number of factors, N is the number of assets.
}
\description{
Compute the factor contributions to standard deviation (SD), Value-at-Risk (VaR), 
Expected Tail Loss or Expected Shortfall (ES) of the return of individual asset within a portfolio 
return of a portfolio based on Euler's theorem, given the fitted factor model.
}
\examples{
\donttest{

# Fundamental Factor Model
library(PCRA)

dateRange <- c("2006-01-31","2010-12-31")
stockItems <-  c("Date", "TickerLast",  "Return","Sector")
factorItems <- c("BP","Beta60M","PM12M1M")
facDatIT <- selectCRSPandSPGMI("monthly",
                               dateRange = dateRange, 
                               stockItems = stockItems, 
                               factorItems = factorItems, 
                               outputType = "data.table")
asset.var="TickerLast" 
ret.var="Return" 
date.var = "Date"
exposure.vars= factorItems
asset.var="TickerLast" 
ret.var="Return" 
date.var = "Date"
spec1 <- specFfm(data = facDatIT,asset.var = asset.var, ret.var = ret.var, 
                date.var = date.var, exposure.vars = exposure.vars,weight.var = NULL,
                 addIntercept = TRUE, rob.stats = FALSE)
# fit a fundamental factor model
mdlFit <- fitFfmDT(spec1)
mdlRes <- extractRegressionStats(spec1,mdlFit)
fit.cross <- convert(SpecObj = spec1,FitObj = mdlFit, RegStatsObj = mdlRes)
repRisk(fit.cross, risk = "Sd", decomp = 'FCR', nrowPrint = 10,  digits = 4) 
# get the factor contributions of risk 
repRisk(fit.cross, risk = "Sd", decomp = 'FPCR', 
        nrowPrint = 10)       
           
# portfolio only decomposition
repRisk(fit.cross, risk = c("VaR", "ES"), decomp = 'FPCR', 
        portfolio.only = TRUE)    
           
# plot
repRisk(fit.cross, risk = "Sd", decomp = 'FPCR', 
        isPrint = FALSE, nrowPrint = 15, isPlot = TRUE, layout = c(4,2))  
}
}
\seealso{
\code{\link{fitFfm}}
for the different factor model fitting functions.
}
\author{
Douglas Martin, Lingjie Yi
}
