% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_levels.R
\name{cross_levels}
\alias{cross_levels}
\alias{link_levels}
\title{Creates panel or cross-classified data}
\usage{
cross_levels(by = NULL, ...)

link_levels(N = NULL, by = NULL, ...)
}
\arguments{
\item{by}{The result of a call to \code{join_using()} which specifies how
the cross-classified data will be created}

\item{...}{A variable or series of variables to add to the resulting data
frame after the cross-classified data is created.}

\item{N}{The number of observations in the resulting data frame.
If \code{N} is NULL or not provided, the join_using will be an "outer product" --
merging each row of each provided data frame with each other data frame to
make a full panel.}
}
\value{
data.frame
}
\description{
This function allows the user to create data structures that are paneled or
cross-classified: where one level of observation draws simultaneously from
two or many source levels. Common examples of panels include country-year
data which have country-level and year-level characteristics.
}
\details{
By specifying the appropriate arguments in \code{join_using()} within the
function call, it is possible to induce correlation in cross-classified data.
}
\examples{

# Generate full panel data
panel <- fabricate(
 countries = add_level(N = 20, country_shock = runif(N, 1, 10)),
 years = add_level(N = 20, year_shock = runif(N, 1, 10), nest=FALSE),
 obs = cross_levels(by = join_using(countries, years), GDP_it = country_shock + year_shock)
)

# Include an "N" argument to allow for cross-classified
# data.
students <- fabricate(
 primary_school = add_level(N = 20, ps_quality = runif(N, 1, 10)),
 secondary_school = add_level(N = 15, ss_quality = runif(N, 1, 10), nest=FALSE),
 students = link_levels(N = 500, by = join_using(primary_school, secondary_school))
)
head(students)

# Induce a correlation structure in cross-classified data by providing
# rho.
students <- fabricate(
 primary_school = add_level(N = 20, ps_quality = runif(N, 1, 10)),
 secondary_school = add_level(N = 15, ss_quality = runif(N, 1, 10), nest=FALSE),
 students = link_levels(N = 500, by = join_using(ps_quality, ss_quality, rho = 0.5))
)
cor(students$ps_quality, students$ss_quality)

}
