% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refit.R
\name{refit.mdl_df}
\alias{refit.mdl_df}
\alias{refit.mdl_ts}
\title{Refit a mable to a new dataset}
\usage{
\method{refit}{mdl_df}(object, new_data, ...)

\method{refit}{mdl_ts}(object, new_data, ...)
}
\arguments{
\item{object}{A mable.}

\item{new_data}{A tsibble dataset used to refit the model.}

\item{...}{Additional optional arguments for refit methods.}
}
\description{
Applies a fitted model to a new dataset. For most methods this can be done
with or without re-estimation of the parameters.
}
\examples{
\dontshow{if (requireNamespace("fable", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(fable)

fit <- as_tsibble(mdeaths) \%>\% 
  model(ETS(value ~ error("M") + trend("A") + season("A")))
fit \%>\% report()

fit \%>\% 
  refit(as_tsibble(fdeaths)) \%>\% 
  report(reinitialise = TRUE)
\dontshow{\}) # examplesIf}
}
