% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{refit.ARIMA}
\alias{refit.ARIMA}
\title{Refit an ARIMA model}
\usage{
\method{refit}{ARIMA}(object, new_data, specials = NULL, reestimate = FALSE, ...)
}
\arguments{
\item{object}{A model for which forecasts are required.}

\item{new_data}{A tsibble containing the time points and exogenous regressors to produce forecasts for.}

\item{specials}{(passed by \code{\link[fabletools:forecast]{fabletools::forecast.mdl_df()}}).}

\item{reestimate}{If \code{TRUE}, the coefficients for the fitted model will be re-estimated to suit the new data.}

\item{...}{Other arguments passed to methods}
}
\value{
A refitted model.
}
\description{
Applies a fitted ARIMA model to a new dataset.
}
\examples{
lung_deaths_male <- as_tsibble(mdeaths)
lung_deaths_female <- as_tsibble(fdeaths)

fit <- lung_deaths_male \%>\%
  model(ARIMA(value ~ 1 + pdq(2, 0, 0) + PDQ(2, 1, 0)))

report(fit)

fit \%>\%
  refit(lung_deaths_female) \%>\%
  report()
}
