% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fHMM_parameters.R
\name{parameter_transformations}
\alias{parameter_transformations}
\alias{par2parUncon}
\alias{parUncon2parCon}
\alias{parCon2par}
\alias{par2parCon}
\alias{parCon2parUncon}
\alias{parUncon2par}
\alias{muCon2muUncon}
\alias{muUncon2muCon}
\alias{sigmaCon2sigmaUncon}
\alias{sigmaUncon2sigmaCon}
\alias{dfCon2dfUncon}
\alias{dfUncon2dfCon}
\alias{Gamma2gammasCon}
\alias{Gamma2gammasUncon}
\alias{gammasCon2Gamma}
\alias{gammasCon2gammasUncon}
\alias{gammasUncon2Gamma}
\alias{gammasUncon2gammasCon}
\title{Parameter transformations}
\usage{
par2parUncon(par, controls, use_parameter_labels = TRUE)

parUncon2parCon(
  parUncon,
  controls,
  use_parameter_labels = TRUE,
  numerical_safeguard = FALSE
)

parCon2par(parCon, controls, use_parameter_labels = TRUE)

par2parCon(par, controls, use_parameter_labels = TRUE)

parCon2parUncon(parCon, controls, use_parameter_labels = TRUE)

parUncon2par(
  parUncon,
  controls,
  use_parameter_labels = TRUE,
  numerical_safeguard = FALSE
)

muCon2muUncon(muCon, link, prefix = "muUncon_", use_parameter_labels = TRUE)

muUncon2muCon(muUncon, link, prefix = "muCon_", use_parameter_labels = TRUE)

sigmaCon2sigmaUncon(
  sigmaCon,
  prefix = "sigmaUncon_",
  use_parameter_labels = TRUE
)

sigmaUncon2sigmaCon(
  sigmaUncon,
  prefix = "sigmaCon_",
  use_parameter_labels = TRUE,
  numerical_safeguard = FALSE
)

dfCon2dfUncon(dfCon, prefix = "dfUncon_", use_parameter_labels = TRUE)

dfUncon2dfCon(
  dfUncon,
  prefix = "dfCon_",
  use_parameter_labels = TRUE,
  numerical_safeguard = FALSE
)

Gamma2gammasCon(
  Gamma,
  prefix = "gammasCon_",
  use_parameter_labels = TRUE,
  numerical_safeguard = FALSE
)

Gamma2gammasUncon(Gamma, prefix = "gammasUncon_", use_parameter_labels = TRUE)

gammasCon2Gamma(gammasCon, dim, prefix = "state_", use_parameter_labels = TRUE)

gammasCon2gammasUncon(
  gammasCon,
  dim,
  prefix = "gammasUncon_",
  use_parameter_labels = TRUE
)

gammasUncon2Gamma(
  gammasUncon,
  dim,
  prefix = "state_",
  use_parameter_labels = TRUE,
  numerical_safeguard = FALSE
)

gammasUncon2gammasCon(
  gammasUncon,
  dim,
  prefix = "gammasCon_",
  use_parameter_labels = TRUE,
  numerical_safeguard = FALSE
)
}
\arguments{
\item{par}{An object of class \code{\link{fHMM_parameters}}, which is a \code{list}
of model parameters.}

\item{controls}{Either a \code{list} or an object of class \code{fHMM_controls}.

The \code{list} can contain the following elements, which are described
in more detail below:
\itemize{
\item \code{hierarchy}, defines an hierarchical HMM,
\item \code{states}, defines the number of states,
\item \code{sdds}, defines the state-dependent distributions,
\item \code{horizon}, defines the time horizon,
\item \code{period}, defines a flexible, periodic fine-scale time horizon,
\item \code{data}, a \code{list} of controls that define the data,
\item \code{fit}, a \code{list} of controls that define the model fitting
}
Either none, all, or selected elements can be specified.

Unspecified parameters are set to their default values.

Important: Specifications in \code{controls} always override individual
specifications.}

\item{use_parameter_labels}{Either \code{TRUE} to label the parameters or \code{FALSE}, if not (this can
save computation time).}

\item{parUncon}{An object of class \code{parUncon}, which is a \code{numeric} \code{vector}
with identified and unconstrained model parameters in the following order:
\enumerate{
\item non-diagonal transition probabilities \code{gammasUncon}
\item expectations \code{muUncon}
\item standard deviations \code{sigmaUncon} (if any)
\item degrees of freedom \code{dfUncon} (if any)
\item fine-scale parameters for each coarse-scale state, in the same order (if any)
}}

\item{numerical_safeguard}{Either \code{TRUE} or \code{FALSE}, determining whether to apply the
following small corrections to boundary parameters to improve numerical
performance when calculating and optimizing the likelihood function:
\itemize{
\item transition probabilities equal to 0 or 1 are shifted towards the center
by \code{1e-3}
\item standard deviations and degrees of freedom are bounded above by \code{100}
}}

\item{parCon}{An object of class \code{parCon}, which is a \code{numeric} \code{vector}
with identified (and constrained) model parameters in the following order:
\enumerate{
\item non-diagonal transition probabilities \code{gammasCon}
\item expectations \code{muCon}
\item standard deviations \code{sigmaCon} (if any)
\item degrees of freedom \code{dfCon} (if any)
\item fine-scale parameters for each coarse-scale state, in the same order (if any)
}}

\item{muCon, muUncon}{A vector of (un-) constrained expected values.}

\item{link}{Either \code{TRUE} or \code{FALSE}, determining whether to apply the link
function.}

\item{prefix}{A \code{character} prefix for labeling the parameters.}

\item{sigmaCon, sigmaUncon}{A vector of (un-) constrained standard deviations.}

\item{dfCon, dfUncon}{A vector of (un-) constrained degrees of freedom.}

\item{gammasCon, gammasUncon}{A vector of (un-) constrained non-diagonal transition probabilities.}

\item{dim}{An \code{integer}, the dimension of the transition probability matrix.}
}
\value{
For \code{par2parUncon}: a vector of unconstrained model parameters.

For \code{parUncon2parCon}: a vector of constrained model parameters.

For \code{parCon2par}: an object of class \code{\link{fHMM_parameters}}.

For \code{par2parCon}: a vector of constrained model parameters.

For \code{parCon2parUncon}: a vector of unconstrained model parameters.

For \code{parUncon2par}: an object of class \code{fHMM_parameters}.

For \code{muCon2muUncon}: a vector of unconstrained expected values.

For \code{muUncon2muCon}: a vector of constrained expected values.

For \code{sigmaCon2sigmaUncon}: a vector of unconstrained standard
deviations.

For \code{sigmaUncon2sigmaCon}: a vector of constrained standard deviations.

For \code{dfCon2dfUncon}: a vector of unconstrained degrees of freedom.

For \code{dfUncon2dfCon}: a vector of constrained degrees of freedom.

For \code{Gamma2gammasCon}: a vector of constrained non-diagonal matrix
elements (column-wise).

For \code{Gamma2gammasUncon}: a vector of unconstrained non-diagonal matrix
elements (column-wise).

For \code{gammasCon2Gamma}: a transition probability matrix.

For \code{gammasCon2gammasUncon}: a vector of unconstrained non-diagonal
elements of the transition probability matrix.

For \code{gammasUncon2Gamma}: a transition probability matrix.

For \code{gammasUncon2gammasCon}: a vector of constrained non-diagonal
elements of a transition probability matrix.
}
\description{
These helper functions transform model parameters between
\itemize{
\item constrained spaces (suffix \code{*Con})
\item and unconstrained spaces (suffix \code{*Uncon}).
}
The former is useful for interpretation, the latter for unconstrained
optimization.
}
\keyword{internal}
