% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.R
\name{explore_count}
\alias{explore_count}
\title{Explore count data (categories + frequency)}
\usage{
explore_count(
  data,
  cat,
  n,
  target,
  pct = FALSE,
  split = TRUE,
  title = NA,
  numeric = FALSE,
  max_cat = 30,
  max_target_cat = 5,
  color = c("lightgrey", "#939FB9"),
  flip = NA
)
}
\arguments{
\item{data}{A dataset (categories + frequency)}

\item{cat}{Numerical variable}

\item{n}{Number of observations (frequency)}

\item{target}{Target variable}

\item{pct}{Show as percent?}

\item{split}{Split by target (FALSE/TRUE)}

\item{title}{Title of the plot}

\item{numeric}{Display variable as numeric (not category)}

\item{max_cat}{Maximum number of categories to be plotted}

\item{max_target_cat}{Maximum number of categories to be plotted for target (except NA)}

\item{color}{Color for bar}

\item{flip}{Flip plot? (for categorical variables)}
}
\value{
Plot object
}
\description{
Create a plot to explore count data (categories + freuency)
Variable named 'n' is auto detected as Frequency
}
\examples{
library(dplyr)
iris \%>\%
  count(Species) \%>\%
  explore_count(Species)
}
