% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esem_efa.R
\name{esem_efa}
\alias{esem_efa}
\title{Exploratory factor analysis (EFA) for ESEM}
\usage{
esem_efa(
  data,
  nfactors,
  fm = "ML",
  rotate = "geominT",
  scores = "regression",
  residuals = TRUE,
  Target = NULL,
  missing = TRUE
)
}
\arguments{
\item{data}{is a raw data matrix.}

\item{nfactors}{is number of factors to extract}

\item{fm}{is the factoring method.}

\item{rotate}{is the rotation method to be used. The suggested methods are available in  \cite{psych::fa()}}

\item{scores}{is the factor scores to be used in EFA estimation. The default scores are estimated using regression as set in "regression".}

\item{residuals}{is set to FALSE by default. In case the residual matrix is required in the output, this parameter should be set to TRUE}

\item{Target}{is the target rotation matrix to be used. In case no target matrix is provided, EFA proceeds with alternative approach. The list of target rotations are available from \cite{GPArotation}}

\item{missing}{is used with scores set to TRUE. The default is missing=TRUE which imputes missing values using either the median or the mean.}
}
\value{
Eigen values of the common factor solution and reporting results for EFA stage
}
\description{
Exploratory factor analysis (EFA) for ESEM
}
\examples{
sdq_lsac<-sdq_lsac
esem_efa(data=sdq_lsac,
nfactors=5,
fm = 'ML',
rotate="geominT",
scores="regression",
residuals=TRUE,
missing=TRUE)
}
