% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.node.attr.R
\docType{data}
\name{nodal_attributes-API}
\alias{nodal_attributes-API}
\alias{ERGM_GET_VATTR_MULTIPLE_TYPES}
\alias{ergm_get_vattr}
\alias{ergm_get_vattr.AsIs}
\alias{ergm_get_vattr.character}
\alias{ergm_get_vattr.function}
\alias{ergm_get_vattr.formula}
\alias{ergm_attr_levels}
\alias{ergm_attr_levels.numeric}
\alias{ergm_attr_levels.logical}
\alias{ergm_attr_levels.AsIs}
\alias{ergm_attr_levels.character}
\alias{ergm_attr_levels.NULL}
\alias{ergm_attr_levels.matrix}
\alias{ergm_attr_levels.function}
\alias{ergm_attr_levels.formula}
\alias{ERGM_VATTR_SPEC}
\alias{ERGM_VATTR_SPEC_NULL}
\alias{ERGM_LEVELS_SPEC}
\title{Helper functions for specifying nodal attribute levels}
\format{
An object of class \code{character} of length 3.

An object of class \code{character} of length 1.

An object of class \code{character} of length 1.

An object of class \code{character} of length 1.
}
\usage{
ERGM_GET_VATTR_MULTIPLE_TYPES

ergm_get_vattr(
  object,
  nw,
  accept = "character",
  bip = c("n", "b1", "b2", "a"),
  multiple = if (accept == "character") "paste" else "stop",
  ...
)

\method{ergm_get_vattr}{AsIs}(
  object,
  nw,
  accept = "character",
  bip = c("n", "b1", "b2", "a"),
  multiple = if (accept == "character") "paste" else "stop",
  ...
)

\method{ergm_get_vattr}{character}(
  object,
  nw,
  accept = "character",
  bip = c("n", "b1", "b2", "a"),
  multiple = if (accept == "character") "paste" else "stop",
  ...
)

\method{ergm_get_vattr}{`function`}(
  object,
  nw,
  accept = "character",
  bip = c("n", "b1", "b2", "a"),
  multiple = if (accept == "character") "paste" else "stop",
  ...
)

\method{ergm_get_vattr}{formula}(
  object,
  nw,
  accept = "character",
  bip = c("n", "b1", "b2", "a"),
  multiple = if (accept == "character") "paste" else "stop",
  ...
)

ergm_attr_levels(object, attr, nw, levels = sort(unique(attr)), ...)

\method{ergm_attr_levels}{numeric}(object, attr, nw, levels = sort(unique(attr)), ...)

\method{ergm_attr_levels}{logical}(object, attr, nw, levels = sort(unique(attr)), ...)

\method{ergm_attr_levels}{AsIs}(object, attr, nw, levels = sort(unique(attr)), ...)

\method{ergm_attr_levels}{character}(object, attr, nw, levels = sort(unique(attr)), ...)

\method{ergm_attr_levels}{`NULL`}(object, attr, nw, levels = sort(unique(attr)), ...)

\method{ergm_attr_levels}{matrix}(object, attr, nw, levels = sort(unique(attr)), ...)

\method{ergm_attr_levels}{`function`}(object, attr, nw, levels = sort(unique(attr)), ...)

\method{ergm_attr_levels}{formula}(object, attr, nw, levels = sort(unique(attr)), ...)

ERGM_VATTR_SPEC

ERGM_VATTR_SPEC_NULL

ERGM_LEVELS_SPEC
}
\arguments{
\item{object}{An argument specifying the nodal attribute to select
or which levels to include.}

\item{nw}{Network on the LHS of the formula.}

\item{accept}{A character vector listing permitted data types for
the output. See the Details section for the specification.}

\item{bip}{Bipartedness mode: affects either length of attribute
vector returned or the length permited: \code{"n"} for full network,
\code{"b1"} for first mode of a bipartite network, \code{"b2"} for the
second, and \code{"a"} for not adjusting.}

\item{multiple}{Handling of multiple attributes or matrix or data
frame output. See the Details section for the specification.}

\item{...}{Additional argument to the functions of network or to
the formula's environment.}

\item{attr}{A vector of length equal to the number of nodes,
specifying the attribute vector.}

\item{levels}{Starting set of levels to use; defaults to the sorted
list of unique attributes.}

\item{l, a}{arguments to \code{LARGEST}, which is actually a function
that gets processed as a function level spec does.}
}
\value{
\code{ergm_get_vattr} returns a vector of length equal to the
number of nodes giving the selected attribute function or, if
\code{multiple="matrix"}, a matrix whose number of row equals the
number of nodes. Either may also have an attribute \code{"name"}, which
controls the suggested name of the attribute combination.

\code{ergm_attr_levels} returns a vector of levels to use and their order.
}
\description{
These functions are meant to be used in \code{InitErgmTerm} and other
implementations to provide the user with a way to extract nodal
attributes and select their levels in standardized and flexible
ways described under \code{\link{nodal_attributes}}.

\code{ergm_get_vattr} extracts and processes the specified
nodal attribute vector. It is strongly recommended that
\code{\link[=check.ErgmTerm]{check.ErgmTerm()}}'s corresponding
\code{vartype="function,formula,character"} (using the
\code{ERGM_VATTR_SPEC} constant).

\code{ergm_attr_levels} filters the levels of the
attribute.  It is strongly recommended that \code{\link[=check.ErgmTerm]{check.ErgmTerm()}}'s
corresponding
\code{vartype="function,formula,character,numeric,logical,AsIs,NULL"} (using the
\code{ERGM_LEVELS_SPEC} constant).
}
\details{
The \code{accept} argument is meant to allow the user to
quickly check whether the output is of an \emph{acceptable} class or
mode. Typically, if a term accepts a character (i.e.,
categorical) attribute, it will also accept a numeric one,
treating each number as a category label. For this reason, the
following outputs are defined:
\describe{

\item{\code{"character"}}{Accept any mode or class (since it can
be converted to character).}

\item{\code{"numeric"}}{Accept real, integer, or logical.}

\item{\code{"logical"}}{Accept logical.}

\item{\code{"integer"}}{Accept integer or logical.}

\item{\code{"natural"}}{Accept a strictly positive integer.}

\item{\code{"0natural"}}{Accept a nonnegative integer or logical.}

\item{\code{"nonnegative"}}{Accept a nonnegative number or logical.}

\item{\code{"positive"}}{Accept a strictly positive number or logical.}

\item{\code{"index"}}{Accept input appropriate for selecting from an unnamed vector: an integer or a logical; positive integers are returned as they are (\code{bip} ignored), logicals are right-sized, and negative integers reverse the selection (as with vector indexing).}

}

Given that, the \code{multiple} argument controls how passing multiple
attributes or functions that result in vectors of appropriate
dimension are handled: \describe{

\item{\code{"paste"}}{Paste together with dot as the separator.}

\item{\code{"stop"}}{Fail with an error message.}

\item{\code{"matrix"}}{Construct and/or return a matrix whose rows correspond to vertices.}

}
}
\note{
\code{ergm_attr_levels.matrix()} expects \verb{levels=} to be a
\code{\link{list}} with each element having length 2 and containing the
values of the two categorical attributes being crossed. It also
assumes that they are in the same order as the user would like
them in the matrix.
}
\examples{
data(florentine)
ergm_get_vattr("priorates", flomarriage)
ergm_get_vattr(~priorates, flomarriage)
ergm_get_vattr(~cbind(priorates, priorates^2), flomarriage, multiple="matrix")
ergm_get_vattr(c("wealth","priorates"), flomarriage)
ergm_get_vattr(c("wealth","priorates"), flomarriage, multiple="matrix")
ergm_get_vattr(~priorates>30, flomarriage)
ergm_get_vattr(~TRUE, flomarriage, accept="index")
ergm_get_vattr(~-(2:12), flomarriage, accept="index")
(a <- ergm_get_vattr(~cut(priorates,c(-Inf,0,20,40,60,Inf),label=FALSE)-1, flomarriage))
ergm_attr_levels(NULL, a, flomarriage)
ergm_attr_levels(-1, a, flomarriage)
ergm_attr_levels(1:2, a, flomarriage)
ergm_attr_levels(I(1:2), a, flomarriage)
}
\keyword{datasets}
\keyword{internal}
