% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective-information.R
\name{effective_information}
\alias{effective_information}
\title{Effective Information}
\usage{
effective_information(graph, effectiveness = FALSE)
}
\arguments{
\item{graph}{igraph or matrix object.}

\item{effectiveness}{Logical indicating whether or not to return network effectiveness.}
}
\value{
Numeric value indicating the effective information of the network.
}
\description{
Calculates the effective information (EI) of a network, \eqn{G}, according to
the definition provided in Klein & Hoel, 2019. Here, we subtract the
average entropies of the out-weights of nodes in a network, WOUT_average
from the entropy of the average out-weights in the network, WIN_entropy.
}
\examples{
graph <- matrix(
  cbind(
    c(0.0, 1.0, 0.0, 0.0),
    c(0.0, 0.0, 1.0, 0.0),
    c(0.0, 0.0, 0.0, 1.0),
    c(0.0, 0.0, 0.0, 0.0)
  ),
 nrow = 4
) \%>\%
  igraph::graph.adjacency(mode = "directed")

effective_information(graph)

}
