% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohens_g.R
\name{cohens_g}
\alias{cohens_g}
\title{Effect Size for Paired Contingency Tables}
\usage{
cohens_g(x, y = NULL, ci = 0.95, alternative = "two.sided", ...)
}
\arguments{
\item{x}{a numeric vector or matrix. \code{x} and \code{y} can also
    both be factors.}

\item{y}{a numeric vector; ignored if \code{x} is a matrix.  If
    \code{x} is a factor, \code{y} should be a factor of the same length.}

\item{ci}{Confidence Interval (CI) level}

\item{alternative}{a character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"two.sided"} (two-sided CI; default),
\code{"greater"} (one-sided CI) or \code{"less"} (one-sided CI). Partial matching is
allowed (e.g., \code{"g"}, \code{"l"}, \code{"two"}...). See \emph{One-Sided CIs} in
\link{effectsize_CIs}.}

\item{...}{Ignored}
}
\value{
A data frame with the effect size (\code{Cohens_g}, \code{Risk_ratio}
(possibly with the prefix \code{log_}), \code{Cohens_h}) and its CIs (\code{CI_low} and
\code{CI_high}).
}
\description{
Cohen's \emph{g} is an effect size of asymmetry (or marginal heterogeneity) for
dependent (paired) contingency tables ranging between 0 (perfect symmetry)
and 0.5 (perfect asymmetry) (see \code{\link[stats:mcnemar.test]{stats::mcnemar.test()}}). (Note this is not
\emph{not} a measure of (dis)agreement between the pairs, but of (a)symmetry.)
}
\section{Confidence (Compatibility) Intervals (CIs)}{
Confidence intervals are based on the proportion (\eqn{P = g + 0.5})
confidence intervals returned by \code{\link[stats:prop.test]{stats::prop.test()}} (minus 0.5), which give
a good close approximation.
}

\section{CIs and Significance Tests}{
"Confidence intervals on measures of effect size convey all the information
in a hypothesis test, and more." (Steiger, 2004). Confidence (compatibility)
intervals and p values are complementary summaries of parameter uncertainty
given the observed data. A dichotomous hypothesis test could be performed
with either a CI or a p value. The 100 (1 - \eqn{\alpha})\% confidence
interval contains all of the parameter values for which \emph{p} > \eqn{\alpha}
for the current data and model. For example, a 95\% confidence interval
contains all of the values for which p > .05.
\cr\cr
Note that a confidence interval including 0 \emph{does not} indicate that the null
(no effect) is true. Rather, it suggests that the observed data together with
the model and its assumptions combined do not provided clear evidence against
a parameter value of 0 (same as with any other value in the interval), with
the level of this evidence defined by the chosen \eqn{\alpha} level (Rafi &
Greenland, 2020; Schweder & Hjort, 2016; Xie & Singh, 2013). To infer no
effect, additional judgments about what parameter values are "close enough"
to 0 to be negligible are needed ("equivalence testing"; Bauer & Kiesser,
1996).
}

\examples{

data("screening_test")

phi(screening_test$Diagnosis, screening_test$Test1)

phi(screening_test$Diagnosis, screening_test$Test2)

# Both tests seem comparable - but are the tests actually different?

(tests <- table(Test1 = screening_test$Test1, Test2 = screening_test$Test2))

mcnemar.test(tests)

cohens_g(tests)

# Test 2 gives a negative result more than test 1!

}
\references{
\itemize{
\item Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd Ed.). New York: Routledge.
}
}
\seealso{
Other effect sizes for contingency table: 
\code{\link{oddsratio}()},
\code{\link{phi}()}
}
\concept{effect sizes for contingency table}
