% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-constructor.R
\name{lamp}
\alias{lamp}
\title{Constructor of lamp class}
\usage{
lamp(
  lambda = NaN,
  T.inf = 86400 * 1000,
  rnd.n = 1e+06,
  alpha = NaN,
  beta = 0,
  rnd.walk = 1,
  sd = NaN,
  sd.method = 0,
  N.lower = 0,
  N.upper = 1000,
  file = character(0)
)
}
\arguments{
\item{lambda}{numeric, the lambda parameter. Must be positive. Default is NaN.}

\item{T.inf}{numeric, the infinite bound to cut off Levy sums. Default is 86400000.}

\item{rnd.n}{numeric, the length of one rnd call. Default is 1000000.}

\item{alpha}{numeric, optional, if you don't like to use lambda. Default is NaN.
Either lambda or alpha must be specified with a positive number.}

\item{beta}{numeric, the skewness parameter. Default: 0.}

\item{rnd.walk}{numeric, random walk method, 1: Laplace, 2: Binomial/normal. Default is 1.}

\item{sd}{numeric, standard deviation adjustment. No adjustment if NaN. Default is NaN.}

\item{sd.method}{numeric, methodology of sd adjustment. 0 means in scale parameter, 1 means in Levy sums. Default is 0.}

\item{N.lower}{numeric, the lower bound of N to truncate the boundary effect. Default is 0.}

\item{N.upper}{numeric, the upper bound of N to limit the outliers. Default is 1000.}

\item{file}{character, file path to save the object and simulation result. Default is character(0).}
}
\value{
an object of lamp class
}
\description{
Construct an lamp class by providing the required parameters.
The default is the unit quartic lambda process.
}
\examples{
lp <- lamp(4, T.inf=86400*1000000)

}
\author{
Stephen H-T. Lihn
}
\keyword{constructor}
