% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lik_GaussianPIC}
\alias{lik_GaussianPIC}
\title{Helper Function - generate likelihood for pair (L,R) and mean gr}
\usage{
lik_GaussianPIC(L, R, gr, s1)
}
\arguments{
\item{L}{numeric vector of lower bounds}

\item{R}{numeric vector of upper bounds}

\item{gr}{numeric vector of means}

\item{s1}{numeric vector of standard deviations}
}
\value{
the likelihood under partial interval censoring
}
\description{
Compute P(L_i, R_i | theta = t_k) for observations (L_i, R_i) and grid of
mean t_k.
}
\examples{
# set-up
p = 15
gr = stats::rnorm(p)
L = R = stats::rnorm(p)
missing.idx = sample.int(n = p, size = p/5)
L[missing.idx] = L[missing.idx] - stats::runif(length(missing.idx), 0, 1)
R[missing.idx] = R[missing.idx] + stats::runif(length(missing.idx), 0, 1)

# R solution
lik = prod(ifelse(
           L == R,
           stats::dnorm(L-gr),
           stats::pnorm(R-gr) - stats::pnorm(L-gr)))

# Compare R to RcppParallel method
all.equal(lik, lik_GaussianPIC(L, R, gr, rep(1,p)))
}
