% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_dual-class.R
\name{dual-class}
\alias{dual-class}
\alias{dual}
\alias{initialize,dual-method}
\alias{is.dual}
\alias{is.dual,ANY,dual-method}
\alias{show,dual-method}
\title{Dual object class
An S4 Class for dual numbers}
\usage{
dual(f, grad)

\S4method{initialize}{dual}(.Object, f = numeric(0), grad = numeric(0))

dual(f, grad)

is.dual(x)

\S4method{show}{dual}(object)
}
\arguments{
\item{f}{a single numeric value denoting the "Real" component of the dual number.}

\item{grad}{a numeric vector rappresenting the "Dual" components of the dual number.}

\item{.Object}{an object of class \code{dual} to be initialized}

\item{x}{an object of class \code{dual}.}

\item{object}{an object of class \code{dual} to be shown}
}
\value{
an object of the class \code{dual}.

a logical value indicating if the object is of the class \code{dual} or not.
}
\description{
The method \code{initialize} sets the initial values of a new object of the class \code{dual}.

The function \code{dual} generates an object of class \code{dual} for the representation of dual numbers.

The function \code{is.dual} returns \code{TRUE} if \code{x} is of the class \code{dual}. It retuns \code{FALSE} otherwise.

The method \code{show} shows the content of a \code{dual} object.
}
\section{Slots}{

\describe{
\item{\code{f}}{a single numeric value denoting the "Real" component of the dual number}

\item{\code{grad}}{a numeric vector rappresenting the "Dual" components of the dual number}
}}

\examples{
x <- dual(3, 0:1)
library(dual)
x <- new("dual", f = 1, grad = 1)
is.dual(3)
is.dual(x)
}
