% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpseg.R
\name{addLm}
\alias{addLm}
\title{Adds linear regression data to \code{dpseg}
results or a table of segment borders.}
\usage{
addLm(dpseg, x, y)
}
\arguments{
\item{dpseg}{result object (class "dpseg") returned by function
\code{\link{dpseg}} or simply a segment table with "start" and
"end" indices}

\item{x}{original x-data used}

\item{y}{original y-data used}
}
\value{
Returns the input \code{dpseg} object or segment table, but
    with original \code{xy} data and \code{fit} results from a
    linear regression with base R (\code{lm(y~x)}) added to the
    results and linear regression coefficient and goodness of fit
    meaurs in the main \code{segments} table.
}
\description{
\code{addLm} takes a segment table (with start/end columns) or a
result object from code \code{\link{dpseg}}, calls base R function
\code{\link{lm}} for each segment, and adds slope, intercept, r2 and
variance of residuals to the segment table. This data is required
for plot and predict method, eg.  when \code{dpseg} was called with
a pre-calculated scoring matrix, or alternative scoring functions
or recursion.
}
\examples{

## 1: run dpseg with store.matrix=TRUE to allow re-rung
segs <- dpseg(x=oddata$Time, y=log(oddata$A3), store.matrix=TRUE)

## 2: run dpseg with score function matrix input
segr <- dpseg(y=segs$SCR,  P=0.0001, verb=1)

## NOTE: only data indices i and j are provided in results
print(segr)

## 3: add original data and linear regression for segments
## NOTE: now also plot and predict methods work
segr <- addLm(segr, x=oddata$Time, y=log(oddata$A3))
print(segr)

}
