% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primary-keys.R
\name{dm_get_all_pks}
\alias{dm_get_all_pks}
\title{Get all primary keys of a \code{\link{dm}} object}
\usage{
dm_get_all_pks(dm, table = NULL, ...)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{table}{One or more table names, unquoted,
to return primary key information for.
If given, primary keys are returned in that order.
The default \code{NULL} returns information for all tables.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A tibble with the following columns:
\describe{
\item{\code{table}}{table name,}
\item{\code{pk_col}}{column name(s) of primary key, as list of character vectors.}
}
}
\description{
\code{dm_get_all_pks()} checks the \code{dm} object for primary keys and
returns the tables and the respective primary key columns.
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_nycflights13() \%>\%
  dm_get_all_pks()
\dontshow{\}) # examplesIf}
}
\seealso{
Other primary key functions: 
\code{\link{dm_add_pk}()},
\code{\link{dm_add_uk}()},
\code{\link{dm_get_all_uks}()},
\code{\link{dm_has_pk}()},
\code{\link{dm_rm_pk}()},
\code{\link{dm_rm_uk}()},
\code{\link{enum_pk_candidates}()}
}
\concept{primary key functions}
