% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_unnest.R
\name{json_unnest}
\alias{json_unnest}
\title{Unnest a JSON column}
\usage{
json_unnest(data, cols, ..., names_sep = NULL, names_repair = "check_unique")
}
\arguments{
\item{data}{A data frame, a data frame extension (e.g. a tibble), or  a lazy
data frame (e.g. from dbplyr or dtplyr).}

\item{cols}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> List-columns to unnest.

When selecting multiple columns, values from the same row will be recycled
to their common size.}

\item{...}{Arguments passed to methods.}

\item{names_sep}{If \code{NULL}, the default, the outer names will come from the
inner names. If a string, the outer names will be formed by pasting
together the outer and the inner column names, separated by \code{names_sep}.}

\item{names_repair}{Used to check that output data frame has valid
names. Must be one of the following options:
\itemize{
\item \verb{"minimal}": no name repair or checks, beyond basic existence,
\item \verb{"unique}": make sure names are unique and not empty,
\item \verb{"check_unique}": (the default), no name repair, but check they are unique,
\item \verb{"universal}": make the names unique and syntactic
\item a function: apply custom name repair.
\item \link[tidyr]{tidyr_legacy}: use the name repair from tidyr 0.8.
\item a formula: a purrr-style anonymous function (see \code{\link[rlang:as_function]{rlang::as_function()}})
}

See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for more details on these terms and the
strategies used to enforce them.}
}
\value{
An object of the same type as \code{data}
}
\description{
A wrapper around \code{\link[tidyr:unnest]{tidyr::unnest()}} that extracts its data from a JSON column.
The inverse of \code{\link[=json_nest]{json_nest()}}.
}
\examples{
tibble(a = 1, b = '[{ "c": 2 }, { "c": 3 }]') \%>\%
  json_unnest(b)
}
