% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZTNegativeBinomial.R
\name{dztnbinom}
\alias{dztnbinom}
\alias{pztnbinom}
\alias{qztnbinom}
\alias{rztnbinom}
\title{The zero-truncated negative binomial distribution}
\usage{
dztnbinom(x, mu, theta, size, log = FALSE)

pztnbinom(q, mu, theta, size, lower.tail = TRUE, log.p = FALSE)

qztnbinom(p, mu, theta, size, lower.tail = TRUE, log.p = FALSE)

rztnbinom(n, mu, theta, size)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{mu}{vector of (non-negative) negative binomial location parameters.}

\item{theta, size}{vector of (non-negative) negative binomial overdispersion parameters.
Only \code{theta} or, equivalently, \code{size} may be specified.}

\item{log, log.p}{logical indicating whether probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical indicating whether probabilities are \eqn{P[X \le x]} (lower tail) or \eqn{P[X > x]} (upper tail).}

\item{p}{vector of probabilities.}

\item{n}{number of random values to return.}
}
\description{
Density, distribution function, quantile function, and random
generation for the zero-truncated negative binomial distribution with
parameters \code{mu} and \code{theta} (or \code{size}).
}
\details{
The negative binomial distribution left-truncated at zero (or zero-truncated
negative binomial for short) is the distribution obtained, when considering
a negative binomial variable Y conditional on Y being greater than zero.

All functions follow the usual conventions of d/p/q/r functions
in base R. In particular, all four \code{ztnbinom} functions for the
zero-truncated negative binomial distribution call the corresponding \code{nbinom}
functions for the negative binomial distribution from base R internally.
}
\examples{
## theoretical probabilities for a zero-truncated negative binomial distribution
x <- 0:8
p <- dztnbinom(x, mu = 2.5, theta = 1)
plot(x, p, type = "h", lwd = 2)

## corresponding empirical frequencies from a simulated sample
set.seed(0)
y <- rztnbinom(500, mu = 2.5, theta = 1)
hist(y, breaks = -1:max(y) + 0.5)

}
\seealso{
\code{\link{ZTNegativeBinomial}}, \code{\link{dnbinom}}
}
\keyword{distribution}
