% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NegativeBinomial.R
\name{random.NegativeBinomial}
\alias{random.NegativeBinomial}
\title{Draw a random sample from a negative binomial distribution}
\usage{
\method{random}{NegativeBinomial}(x, n = 1L, drop = TRUE, ...)
}
\arguments{
\item{x}{A \code{NegativeBinomial} object created by a call to
\code{\link[=NegativeBinomial]{NegativeBinomial()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
In case of a single distribution object or \code{n = 1}, either a numeric
vector of length \code{n} (if \code{drop = TRUE}, default) or a \code{matrix} with \code{n} columns
(if \code{drop = FALSE}).
}
\description{
Draw a random sample from a negative binomial distribution
}
\examples{

set.seed(27)

X <- NegativeBinomial(size = 5, p = 0.1)
X

random(X, 10)

pdf(X, 50)
log_pdf(X, 50)

cdf(X, 50)
quantile(X, 0.7)

## alternative parameterization of X
Y <- NegativeBinomial(mu = 45, size = 5)
Y
cdf(Y, 50)
quantile(Y, 0.7)
}
\seealso{
Other NegativeBinomial distribution: 
\code{\link{cdf.NegativeBinomial}()},
\code{\link{pdf.NegativeBinomial}()},
\code{\link{quantile.NegativeBinomial}()}
}
\concept{NegativeBinomial distribution}
