% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZTNegativeBinomial.R
\name{cdf.ZTNegativeBinomial}
\alias{cdf.ZTNegativeBinomial}
\title{Evaluate the cumulative distribution function of a zero-truncated negative binomial distribution}
\usage{
\method{cdf}{ZTNegativeBinomial}(d, x, drop = TRUE, elementwise = NULL, ...)
}
\arguments{
\item{d}{A \code{ZTNegativeBinomial} object created by a call to \code{\link[=ZTNegativeBinomial]{ZTNegativeBinomial()}}.}

\item{x}{A vector of elements whose cumulative probabilities you would
like to determine given the distribution \code{d}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{elementwise}{logical. Should each distribution in \code{d} be evaluated
at all elements of \code{x} (\code{elementwise = FALSE}, yielding a matrix)?
Or, if \code{d} and \code{x} have the same length, should the evaluation be
done element by element (\code{elementwise = TRUE}, yielding a vector)? The
default of \code{NULL} means that \code{elementwise = TRUE} is used if the
lengths match and otherwise \code{elementwise = FALSE} is used.}

\item{...}{Arguments to be passed to \code{\link{pztnbinom}}.
Unevaluated arguments will generate a warning to catch mispellings or other
possible errors.}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(x)} columns (if \code{drop = FALSE}). In case of a vectorized distribution
object, a matrix with \code{length(x)} columns containing all possible combinations.
}
\description{
Evaluate the cumulative distribution function of a zero-truncated negative binomial distribution
}
\examples{
## set up a zero-truncated negative binomial distribution
X <- ZTNegativeBinomial(mu = 2.5, theta = 1)
X

## standard functions
pdf(X, 0:8)
cdf(X, 0:8)
quantile(X, seq(0, 1, by = 0.25))

## cdf() and quantile() are inverses for each other
quantile(X, cdf(X, 3))

## density visualization
plot(0:8, pdf(X, 0:8), type = "h", lwd = 2)

## corresponding sample with histogram of empirical frequencies
set.seed(0)
x <- random(X, 500)
hist(x, breaks = -1:max(x) + 0.5)
}
