% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar.wtd.R
\name{polar.wtd}
\alias{polar.wtd}
\title{Polarization index}
\source{
Wolny-Dominiak, A. and A. Saczewska-Piotrowska (2017). affluenceIndex: Affluence Indices.
 R package version 1.0. https://CRAN.R-project.org/package=affluenceIndex
}
\usage{
polar.wtd(x, weights = NULL)
}
\arguments{
\item{x}{a numeric vector.}

\item{weights}{an optional vector of weights of x to be used in the computation of the
Polarization index. Should be NULL or a numeric vector.}
}
\value{
The value of the Wolfson polarization index.
}
\description{
Returns the (possibly weighted) polarization index for a vector. The Wolfson
index of bipolarization is used.

A bipolarized (income) distribution has fewer observations in the middle and more in lower
and/or higher part of the distribution. The regular measures of inequality (like the gini
coefficient) does not give information about the polarization of the distribution. This
Polarization index computes the level of bipolarization of the distribution. The concept is
closely related to the Lorenz curve and therefore the scalar measure is also related to the
Gini coefficient. A lower number means a lower level of polarization.

Extension of the polar.aff function in affluence-index package. Option of weighting the index
is included.
}
\examples{
#calculate Polarization Index using Mexican Income data set
data(mex_inc_2008)

#unweighted Polarization Index:
polar.wtd(mex_inc_2008$income)

#weighted Polarization Index:
polar.wtd(x=mex_inc_2008$income, weights=mex_inc_2008$factor)

}
\references{
Wolfson M. (1994) When inequalities diverge, \emph{The American Economic Review}, 84, p. 353-358.

Schmidt, A. (2002) Statistical Measurement of Income Polarization. A Cross-National, \emph{Berlin 10th
International conference on panel data.}
}
