% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensio-internal.R
\name{prepare}
\alias{prepare}
\title{Prepare Data for Plotting}
\usage{
prepare(
  x,
  margin,
  axes = c(1, 2),
  active = TRUE,
  sup = TRUE,
  principal = TRUE,
  highlight = NULL,
  reorder = TRUE,
  color = NULL,
  fill = FALSE,
  shape = NULL,
  size = c(1, 6),
  line_type = NULL,
  line_width = size,
  ...
)
}
\arguments{
\item{x}{A \code{\linkS4class{MultivariateAnalysis}} object.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript
which the data will be returned: \code{1} indicates individuals/rows (the
default), \code{2} indicates variables/columns.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions to be
plotted.}

\item{active}{A \code{\link{logical}} scalar: should the active observations be
plotted?}

\item{sup}{A \code{\link{logical}} scalar: should the supplementary observations be
plotted?}

\item{principal}{A \code{\link{logical}} scalar: should principal coordinates be
returned? If \code{FALSE}, standard coordinates are returned.}

\item{highlight}{A vector specifying the information to be highlighted.
If \code{NULL} (the default), no highlighting is applied. If a single \code{character}
string is passed, it must be the name of a categorical variable, or one of
"\code{observation}", "\code{mass}", "\code{sum}", "\code{contribution}" or "\code{cos2}"
(see \code{\link[=augment]{augment()}}).}

\item{color}{The colors for lines and points (will be mapped to \code{highlight}).
Ignored if set to \code{FALSE}.}

\item{shape}{A vector of plotting characters or symbols (will be mapped to
\code{highlight}). This can either be a single character or an integer code for
one of a set of graphics symbols. Ignored if set to \code{FALSE}.}

\item{size}{A length-two \code{\link{numeric}} vector giving range of possible sizes
(greater than 0; will be mapped to \code{highlight}). Ignored if set to \code{FALSE}.}

\item{line_type, line_width}{A specification for the line type and width (will
be mapped to \code{highlight}). Ignored if set to \code{FALSE}.}
}
\value{
A \code{\link{data.frame}} with the following columns:
\describe{
\item{\code{x}}{Coordinates along x.}
\item{\code{y}}{Coordinates along y.}
\item{\code{z}}{Variable to be highlighted.}
\item{\code{label}}{Label.}
\item{\code{sup}}{Is supplementary?}
\item{\code{col}}{Color for lines and points.}
\item{\code{bg}}{Background color.}
\item{\code{pch}}{Symbol.}
\item{\code{cex}}{Symbol size.}
\item{\code{lty}}{Line type.}
\item{\code{lwd}}{Line width.}
}
}
\description{
Prepare Data for Plotting
}
\author{
N. Frerebeau
}
\keyword{internal}
