% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uLSIF.R
\name{uLSIF}
\alias{uLSIF}
\title{Estimate Density Ratio p(x)/q(x) by uLSIF (unconstrained Least-Square Importance Fitting)}
\usage{
uLSIF(x1, x2, sigma = 10^seq(-3, 1, length.out = 9),
  lambda = 10^seq(-3, 1, length.out = 9), kernel_num = 100,
  verbose = TRUE)
}
\arguments{
\item{x1}{numeric vector or matrix. Data from a numerator distribution p(x).}

\item{x2}{numeric vector or matrix. Data from a denominator distribution q(x).}

\item{sigma}{positive numeric vector. Search range of Gaussian kernel bandwidth.}

\item{lambda}{positive numeric vector. Search range of regularization parameter.}

\item{kernel_num}{positive integer. Number of kernels.}

\item{verbose}{logical(default TRUE).}
}
\value{
uLSIF object that contains a function to compute estimated density ratio.
}
\description{
Estimate Density Ratio p(x)/q(x) by uLSIF (unconstrained Least-Square Importance Fitting)
}
