% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_inference.R
\name{dcNetwork}
\alias{dcNetwork}
\title{Generate a differential network from a DC analysis}
\usage{
dcNetwork(dcscores, dcpvals = NULL, thresh = NULL, ...)
}
\arguments{
\item{dcscores}{a matrix, the result of the \code{dcScore} function. The
results should be passed as produced by the function and not modified in
intermediate steps}

\item{dcpvals}{a matrix or NULL, raw or adjusted p-values resulting from
\code{dcTest} or \code{dcAdjust} respectively. Should be left NULL only if
method is EBcoexpress or DiffCoEx}

\item{thresh}{a numeric, threshold to apply. If \code{NULL}, defaults to 0.1
for methods that generate a p-value, 0.9 for posterior probabilities from
EBcoexpress and 0.1 on the absolute score from DiffCoEx}

\item{...}{see details}
}
\value{
an igraph object, representing the differential network. Scores are
  added as edge attributes with the name 'score'
}
\description{
Threshold the results from a differential co-expression analysis
  and create a differential network.
}
\details{
No extra arguments required for this function. The ellipsis are used
  to allow flexibility in pipelines.
}
\examples{
#create data
set.seed(360)
x <- matrix(rnorm(120), 4, 30)
cond <- rep(1:2, 15)

#perform analysis - z-score
zscores <- dcScore(x, cond)
pvals <- dcTest(zscores, emat = x, condition = cond)
pvals <- dcAdjust(pvals, p.adjust, method = 'fdr')
ig <- dcNetwork(zscores, pvals, 0.1)

#perform analysis - DiffCoEx
dcscores <- dcScore(x, cond, dc.method = 'diffcoex')
ig <- dcNetwork(dcscores, thresh = 0.001)

#plot the resulting differential co-expression network
igraph::plot.igraph(ig)

}
\seealso{
\code{\link{dcScore}}, \code{\link{dcTest}}, \code{\link{dcAdjust}}
}
