#' Autocovariance function estimation via difference-based methods
#' 
#' Difference-based (auto)covariance/correlation estimation in change point 
#' regression with stationary errors.
#'   
#' Provides bias-reducing methods for (auto)covariance-correlation 
#' estimation in change point regression with stationary \eqn{m}-dependent errors 
#' without having to pre-estimate the underlying signal of the observations.    
#' In the same spirit, provides a robust estimator of the autorregressive coefficient
#' in change point regression with stationary, \eqn{AR(1)} errors.
#' It also includes a general projection-based method for covariance matrix estimation.
#' 
#' @name dbacf-package
#' @author Tecuapetla-Gómez, I. \email{itecuap@@conabio.gob.mx}
#'  
#' @section Autocovariance Estimation:
#' \code{\link{dbacf}} returns \emph{and plots by default} (auto)covariance/correlation 
#' estimates without pre-estimating the underlying \emph{not necessarily smooth} 
#' signal of observations with \emph{stationary} \eqn{m}-dependent errors. The corresponding
#' plot method \code{\link[dbacf]{plot.dbacf}} allows for adjusting graphical 
#' parameters to users' liking. This method is based on \code{\link[stats]{plot.acf}}.
#' 
#' \code{\link{dbacf_AR1}} returns (auto)covariance/correlation estimates while
#' circumventing the difficult estimation of the underlying change point regression
#' function from observations with stationary \eqn{AR(1)} errors. 
#' 
#' @section Covariance Matrix Estimation:
#' Given a matrix estimate, \emph{not necessarily positive definite}, of
#' the covariance matrix of a stationary process,
#' \code{\link{nearPDToeplitz}} returns the nearest, \emph{in the Frobenius norm}, 
#' covariance matrix to the initial estimate. See \code{\link{projectToeplitz}} 
#' for the projection of a given symmetric matrix onto the space of Toeplitz matrices.
#' See also \code{\link{symBandedToeplitz}} for creating a (stationary process'
#' large covariance) matrix by specifying its dimension and values of its 
#' autocovariance function.
#' 
#' @references Grigoriadis, K.M., Frazho, A., Skelton, R. (1994). 
#' \emph{Application of alternating convex projection methods for computation 
#' of positive Toeplitz matrices}, IEEE Transactions on signal processing 
#' \bold{42(7)}, 1873--1875.
#'  
#' @references N. Higham (2002). \emph{Computing the nearest correlation matrix - a
#' problem from finance}, Journal of Numerical Analysis \bold{22}, 329--343.
#' 
#' @references Tecuapetla-Gómez, I and Munk, A. (2017). \emph{Autocovariance
#' estimation in regression with a discontinuous signal and \eqn{m}-dependent errors: A 
#' difference-based approach}. Scandinavian Journal of Statistics, \bold{44(2)}, 346--368.
#' 
#' @references Levine, M. and Tecuapetla-Gómez, I. (2023). \emph{Autocovariance 
#' function estimation via difference schemes for a semiparametric change point model
#' with \eqn{m}-dependent errors}. Submitted.
#' 
#' @keywords package
#' @docType package
NULL