% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dann.R
\name{dann}
\alias{dann}
\title{Discriminant Adaptive Nearest Neighbor Classification}
\usage{
dann(x, ..., k = 5, neighborhood_size = max(floor(nrow(x)/5), 50), epsilon = 1)
}
\arguments{
\item{x}{A matrix or a dataframe.}

\item{...}{Additional parameters passed to methods.}

\item{k}{The number of data points used for final classification.}

\item{neighborhood_size}{The number of data points used to calculate between and within class covariance.}

\item{epsilon}{Diagonal elements of a diagonal matrix. 1 is the identity matrix.}
}
\value{
An S3 class of type dann.
}
\description{
Discriminant Adaptive Nearest Neighbor Classification
}
\details{
This is an implementation of Hastie and Tibshirani's
\href{https://web.stanford.edu/~hastie/Papers/dann_IEEE.pdf}{Discriminant Adaptive Nearest Neighbor Classification publication.}.
}
