% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_motifs.R
\encoding{UTF-8}
\name{calculate_motifs}
\alias{calculate_motifs}
\title{Computes the relative frequency of motifs in a categorical time series}
\usage{
calculate_motifs(series, categories, motif_length)
}
\arguments{
\item{series}{A CTS.}

\item{categories}{A vector of type factor containing the corresponding
categories.}

\item{motif_length}{The length of the motif.}
}
\value{
Returns an array with the relative frequency of motifs in a
categorical time series.
}
\description{
\code{calculate_motifs} computes the motifs of a categorical time series
}
\details{
Given a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, and a motif length \eqn{L},
the function returns an array of \eqn{r^L} elements, with the element
in the position \eqn{(i_1, i_2, \ldots, i_r)} being the relative frequency
of the motif ``\eqn{i_1i_2 \cdots i_r}'' in the corresponding time series.
}
\examples{
calculate_motifs(GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't')), motif_length = 3)
# Computing the relative frequencies of motifs of length 3 for the first
# series in dataset GeneticSequences
}
\references{
{

  \insertRef{lonardi2002finding}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
