\name{Result wrappers}
\alias{mergeResults}
\alias{overlapResults}

\title{Wrappers to get region-level results}

\description{Convenience wrappers around lower-level functions to easily obtain region-level results from window statistics.}

\usage{
mergeResults(ranges, tab=mcols(ranges), tol, get.best=TRUE, 
    merge.args=list(), combine.args=list(), best.args=list())

overlapResults(ranges, tab=mcols(ranges), regions, get.best=TRUE, 
    overlap.args=list(), combine.args=list(), best.args=list())
}

\arguments{
\item{ranges}{A \linkS4class{GRanges} or \linkS4class{RangedSummarizedExperiment}
containing genomic intervals, usually for windows.}
\item{tab}{A data.frame of differential binding results with one row per interval in \code{ranges},
to be passed to \code{\link{combineTests}} or \code{\link{combineOverlaps}}.}
\item{tol}{A numeric scalar to be passed to \code{\link{mergeWindows}}.}
\item{get.best}{A logical scalar indicating whether \code{\link{getBestTest}} or \code{\link{getBestOverlaps}} should be run.}
\item{regions}{A \linkS4class{GRanges} class containing reference regions to overlap with the windows.}
\item{merge.args}{Further arguments to pass to \code{\link{mergeWindows}}.}
\item{overlap.args}{Further arguments to pass to \code{\link{findOverlaps}}.}
\item{combine.args}{Further arguments to pass to \code{\link{combineTests}} or \code{\link{combineOverlaps}}.}
\item{best.args}{Further arguments to pass to \code{\link{getBestTest}} or \code{\link{getBestOverlaps}}.}
}

\value{
\code{mergeResults} will return a \linkS4class{DataFrame} containing
\code{regions}, the \linkS4class{GRanges} generated by clustering windows into regions;
\code{combined}, the DataFrame containing combined statistics for each clustered region;
and \code{best}, the DataFrame containing statistics for the best window in each clustered region.
The metadata contains \code{ids}, an integer vector of cluster IDs for \code{ranges} from \code{\link{mergeWindows}}.

\code{overlapResults} will return a \linkS4class{DataFrame} containing
\code{regions}, the same as the input \linkS4class{GRanges} of the same name;
\code{combined}, the DataFrame containing combined statistics for each reference region;
and \code{best}, the DataFrame containing statistics for the best window in each reference region.
The metadata contains \code{overlaps}, a \linkS4class{Hits} object specifying the overlaps from \code{\link{findOverlaps}}.
}

\details{
\code{mergeResults} simply calls \code{\link{mergeWindows}} to identify clusters of windows corresponding to regions.
These clusters are used in \code{\link{combineTests}} and (optionally) \code{\link{getBestTest}} to obtain per-region statistics.

\code{overlapResults} simply calls \code{\link{findOverlaps}} to identify all windows overlapping each reference region.
These overlaps are used in \code{\link{combineOverlaps}} and (optionally) \code{\link{getBestOverlaps}},
where each set of overlapping windows for a reference region are used to define the latter's statistics.

These wrapper functions are simply for convenience.
No other work is performed and so users are free to call the individual functions separately.
}

\author{
Aaron Lun
}

\seealso{
\code{\link{mergeWindows}}, \code{\link{combineTests}} and \code{\link{getBestTest}}, 
for the functions that actually do the work in \code{mergeResults}.

\code{\link{findOverlaps}}, \code{\link{combineOverlaps}} and \code{\link{getBestOverlaps}}, 
for the functions that actually do the work in \code{overlapResults}.
}

\examples{
# Making up some data.
tab <- data.frame(logFC=rnorm(20), logCPM=rnorm(20), PValue=rbeta(20, 1, 2))
gr <- GRanges("chrA", IRanges(sample(1000, 20), width=40))

# Merging windows.
(merge.out <- mergeResults(gr, tab, tol=1))
merge.out$merged
merge.out$combined

# Overlapping windows with a reference region.
regions <- GRanges("chrA", IRanges(c(10, 500, 900), width=20))
(olap.out <- overlapResults(gr, tab, regions=regions))
olap.out$regions
olap.out$combined
}

