% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixedTests.R
\name{mixedTests}
\alias{mixedTests}
\alias{mixedClusters}
\title{Tests for mixed DB clusters}
\usage{
mixedTests(
  ids,
  tab,
  weights = NULL,
  pval.col = NULL,
  fc.col = NULL,
  fc.threshold = 0.05
)

mixedClusters(...)
}
\arguments{
\item{ids}{An integer vector or factor containing the cluster ID for each test.}

\item{tab}{A data.frame of results with \code{PValue} and at least one \code{logFC} field for each test.}

\item{weights}{A numeric vector of weights for each test. 
Defaults to 1 for all tests.}

\item{pval.col}{An integer scalar or string specifying the column of \code{tab} containing the p-values.
Defaults to \code{"PValue"}.}

\item{fc.col}{An integer or string specifying the single column of \code{tab} containing the log-fold change.}

\item{fc.threshold}{A numeric scalar specifying the FDR threshold to use \emph{within} each cluster for counting tests changing in each direction, see \code{?"\link{cluster-direction}"} for more details.}

\item{...}{Further arguments to pass to \code{\link{mixedTests}}.}
}
\value{
A \linkS4class{DataFrame} with one row per cluster and various fields:
\itemize{
\item An integer field \code{num.tests}, specifying the total number of tests in each cluster.
\item Two integer fields \code{num.up.*} and \code{num.down.*} for each log-FC column in \code{tab}, containing the number of tests with log-FCs significantly greater or less than 0, respectively.
See \code{?"\link{cluster-direction}"} for more details.
\item A numeric field containing the cluster-level p-value. 
If \code{pval.col=NULL}, this column is named \code{PValue}, otherwise its name is set to \code{colnames(tab[,pval.col])}.
\item A numeric field \code{FDR}, containing the BH-adjusted cluster-level p-value.
\item A character field \code{direction}, set to \code{"mixed"} for all clusters. 
See \code{?"\link{cluster-direction}"} for more details.
\item Two integer fields \code{rep.up.test} and \code{rep.down.test}, containing the row index (for \code{tab}) of representative tests with positive and negative sign, respectively, for each cluster.
See \code{?"\link{cluster-direction}"} for more details.
\item One numeric field \code{rep.up.*} and \code{rep.down.*} for each log-FC column in \code{tab}, containing log-fold changes for the representative tests in the cluster.
See \code{?"\link{cluster-direction}"} for more details.
}
Each row is named according to the ID of the corresponding cluster.
}
\description{
Intersects two one-sided tests to determine if a cluster contains tests with changes in both directions.
}
\details{
This function converts two-sided p-values to one-sided counterparts for each direction of log-fold change.
For each direction, the corresponding one-sided p-values are combined by \code{\link{combineTests}} to yield a combined p-value for each cluster.
Each cluster is associated with two combined p-values (one in each direction), which are intersected using the Berger's intersection-union test (IUT).

The IUT p-value provides evidence against the null hypothesis that either direction is not significant.
In short, a low p-value is only possible if there are significant changes in both directions.
This formally identifies genomic regions containing complex DB events, i.e., where depletion in one subinterval of the bound/enriched region is accompanied by increasing binding in another subinterval. 
Examples include swaps in adjacent TF binding locations between conditions or shifts in histone mark patterns in bidirectional promoters.

We expect that the p-values in \code{pval.col} are two-sided and independent of the sign of the log-fold change under the null hypothesis.
This is true for likelihood ratio tests but may not be true for others (e.g., from \code{\link{glmTreat}}), so caution is required when supplying values in \code{tab}.
}
\examples{
ids <- round(runif(100, 1, 10))
tab <- data.frame(logFC=rnorm(100), logCPM=rnorm(100), PValue=rbeta(100, 1, 2))
mixed <- mixedTests(ids, tab)
head(mixed)

}
\references{
Berger RL and Hsu JC (1996). 
Bioequivalence trials, intersection-union tests and equivalence confidence sets.
\emph{Statist. Sci.} 11, 283-319.
}
\seealso{
\code{\link{combineTests}}, for a more general-purpose method of combining tests.
}
\author{
Aaron Lun
}
