% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_lower.R
\name{cor_lower}
\alias{cor_lower}
\title{Return the upper or lower triangular part}
\usage{
cor_lower(x, diag = FALSE, ...)
}
\arguments{
\item{x}{A correlation object.}

\item{diag}{Should the diagonal be included?}

\item{...}{Other arguments to be passed to or from other functions.}
}
\description{
Return the upper or lower triangular part of the correlation matrix.
}
\examples{
x <- correlation(mtcars, redundant = TRUE) # Generate full matrix
x <- cor_lower(x)

if (require("ggplot2")) {
  ggplot(x, aes(x = Parameter2, y = Parameter1, fill = r)) +
    geom_tile()
}

# Sorted
x <- correlation(mtcars, redundant = TRUE) # Generate full matrix
x <- cor_sort(x)
x <- cor_lower(x)

if (require("ggplot2")) {
  ggplot(x, aes(x = Parameter2, y = Parameter1, fill = r)) +
    geom_tile()
}
}
