% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moment.R
\name{moment}
\alias{moment}
\alias{moment.seqre_result}
\alias{moment.grideval_result}
\title{Obtain Moments from a CopRe or SeqRe Result}
\usage{
moment(obj, mom, cntrl = TRUE, grd = NULL)

\method{moment}{seqre_result}(obj, mom, cntrl = TRUE, grd = NULL)

\method{moment}{grideval_result}(obj, mom, cntrl = TRUE, grd = NULL)
}
\arguments{
\item{obj}{A \code{copre_result} or \code{seqre_result} object.}

\item{mom}{A numeric scalar indicating the moment to calculate.}

\item{cntrl}{A logical value indicating whether the moment should be central
or not. Defaults to \code{TRUE}.}

\item{grd}{A numeric vector of grid values on which the density function
samples in \code{obj} should be calculated for trapezoidal integration.}
}
\value{
A vector of moment values for each sampled distribution in \code{obj}.
}
\description{
Obtain Moments from a CopRe or SeqRe Result
}
\section{Methods (by class)}{
\itemize{
\item \code{moment(seqre_result)}: Moment calculation method for \code{seqre_result} objects.

\item \code{moment(grideval_result)}: Moment calculation method for \code{grideval_result} objects.

}}
