% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-unconstrain_variables}
\alias{fit-method-unconstrain_variables}
\alias{unconstrain_variables}
\title{Transform a set of parameter values to the unconstrained scale}
\usage{
unconstrain_variables(variables)
}
\arguments{
\item{variables}{(list) A list of parameter values to transform, in the same
format as provided to the \code{init} argument of the \verb{$sample()} method.}
}
\description{
The \verb{$unconstrain_variables()} method transforms input
parameters to the unconstrained scale.
}
\examples{
\dontrun{
fit_mcmc <- cmdstanr_example("logistic", method = "sample", force_recompile = TRUE)
fit_mcmc$init_model_methods()
fit_mcmc$unconstrain_variables(list(alpha = 0.5, beta = c(0.7, 1.1, 0.2)))
}

}
\seealso{
\code{\link[=log_prob]{log_prob()}}, \code{\link[=grad_log_prob]{grad_log_prob()}}, \code{\link[=constrain_variables]{constrain_variables()}},
\code{\link[=unconstrain_variables]{unconstrain_variables()}}, \code{\link[=unconstrain_draws]{unconstrain_draws()}}, \code{\link[=variable_skeleton]{variable_skeleton()}},
\code{\link[=hessian]{hessian()}}
}
