% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{as_draws.CmdStanMCMC}
\alias{as_draws.CmdStanMCMC}
\alias{as_draws}
\alias{as_draws.CmdStanMLE}
\alias{as_draws.CmdStanLaplace}
\alias{as_draws.CmdStanVB}
\alias{as_draws.CmdStanGQ}
\alias{as_draws.CmdStanPathfinder}
\title{Create a \code{draws} object from a CmdStanR fitted model object}
\usage{
\method{as_draws}{CmdStanMCMC}(x, ...)

\method{as_draws}{CmdStanMLE}(x, ...)

\method{as_draws}{CmdStanLaplace}(x, ...)

\method{as_draws}{CmdStanVB}(x, ...)

\method{as_draws}{CmdStanGQ}(x, ...)

\method{as_draws}{CmdStanPathfinder}(x, ...)
}
\arguments{
\item{x}{A CmdStanR fitted model object.}

\item{...}{Optional arguments passed to the \code{\link[=fit-method-draws]{$draws()}}
method (e.g., \code{variables}, \code{inc_warmup}, etc.).}
}
\description{
Create a \code{draws} object supported by the \pkg{posterior} package. These
methods are just wrappers around CmdStanR's \code{\link[=fit-method-draws]{$draws()}}
method provided for convenience.
}
\details{
To subset iterations, chains, or draws, use the
\code{\link[posterior:subset_draws]{posterior::subset_draws()}} method after creating the \code{draws} object.
}
\examples{
\dontrun{
fit <- cmdstanr_example()
as_draws(fit)

# posterior's as_draws_*() methods will also work
posterior::as_draws_rvars(fit)
posterior::as_draws_list(fit)
}

}
