% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{CmdStanDiagnose}
\alias{CmdStanDiagnose}
\title{CmdStanDiagnose objects}
\description{
A \code{CmdStanDiagnose} object is the object returned by the
\code{\link[=model-method-diagnose]{$diagnose()}} method of a \code{\link{CmdStanModel}} object.
}
\section{Methods}{
 \code{CmdStanDiagnose} objects have the following associated
methods:\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-gradients]{$gradients()}} \tab Return gradients from diagnostic mode. \cr
   \code{\link[=fit-method-lp]{$lp()}} \tab Return the total log probability density (\code{target}). \cr
   \code{\link[=fit-method-init]{$init()}} \tab Return user-specified initial values. \cr
   \code{\link[=fit-method-metadata]{$metadata()}} \tab Return a list of metadata gathered from the CmdStan CSV files. \cr
   \code{\link[=fit-method-save_output_files]{$save_output_files()}} \tab Save output CSV files to a specified location. \cr
   \code{\link[=fit-method-save_data_file]{$save_data_file()}} \tab Save JSON data file to a specified location. \cr
}
}

\examples{
\dontrun{
test <- cmdstanr_example("logistic", method = "diagnose")

# retrieve the gradients
test$gradients()
}

}
\seealso{
The CmdStanR website
(\href{https://mc-stan.org/cmdstanr/}{mc-stan.org/cmdstanr}) for online
documentation and tutorials.

The Stan and CmdStan documentation:
\itemize{
\item Stan documentation: \href{https://mc-stan.org/users/documentation/}{mc-stan.org/users/documentation}
\item CmdStan User’s Guide: \href{https://mc-stan.org/docs/cmdstan-guide/}{mc-stan.org/docs/cmdstan-guide}
}

Other fitted model objects: 
\code{\link{CmdStanGQ}},
\code{\link{CmdStanLaplace}},
\code{\link{CmdStanMCMC}},
\code{\link{CmdStanMLE}},
\code{\link{CmdStanPathfinder}},
\code{\link{CmdStanVB}}
}
\concept{fitted model objects}
