% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-variable_skeleton}
\alias{fit-method-variable_skeleton}
\alias{variable_skeleton}
\title{Return the variable skeleton for \code{relist}}
\usage{
variable_skeleton(transformed_parameters = TRUE, generated_quantities = TRUE)
}
\arguments{
\item{transformed_parameters}{(logical) Whether to include transformed
parameters in the skeleton (defaults to \code{TRUE}).}

\item{generated_quantities}{(logical) Whether to include generated quantities
in the skeleton (defaults to \code{TRUE}).}
}
\description{
The \verb{$variable_skeleton()} method returns the variable skeleton
needed by \code{utils::relist()} to re-structure a vector of constrained
parameter values to a named list.
}
\examples{
\dontrun{
fit_mcmc <- cmdstanr_example("logistic", method = "sample", force_recompile = TRUE)
fit_mcmc$init_model_methods()
fit_mcmc$variable_skeleton()
}

}
\seealso{
\code{\link[=log_prob]{log_prob()}}, \code{\link[=grad_log_prob]{grad_log_prob()}}, \code{\link[=constrain_variables]{constrain_variables()}},
\code{\link[=unconstrain_variables]{unconstrain_variables()}}, \code{\link[=unconstrain_draws]{unconstrain_draws()}}, \code{\link[=variable_skeleton]{variable_skeleton()}},
\code{\link[=hessian]{hessian()}}
}
