% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-variable_skeleton}
\alias{fit-method-variable_skeleton}
\alias{variable_skeleton}
\title{Return the variable skeleton needed by the utils::relist function to re-structure a
vector of constrained parameter values to a named list}
\usage{
variable_skeleton(transformed_parameters = TRUE, generated_quantities = TRUE)
}
\arguments{
\item{transformed_parameters}{(boolean) Whether to include transformed parameters
in the skeleton (defaults to TRUE)}

\item{generated_quantities}{(boolean) Whether to include generated quantities
in the skeleton (defaults to TRUE)}
}
\description{
The \verb{$variable_skeleton()} method returns the variable skeleton
}
\examples{
\dontrun{
fit_mcmc <- cmdstanr_example("logistic", method = "sample")
fit_mcmc$init_model_methods()
fit_mcmc$variable_skeleton()
}

}
\seealso{
\code{\link[=log_prob]{log_prob()}}, \code{\link[=grad_log_prob]{grad_log_prob()}}, \code{\link[=constrain_variables]{constrain_variables()}},
\code{\link[=unconstrain_variables]{unconstrain_variables()}}, \code{\link[=unconstrain_draws]{unconstrain_draws()}}, \code{\link[=variable_skeleton]{variable_skeleton()}},
\code{\link[=hessian]{hessian()}}
}
