% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-loo}
\alias{fit-method-loo}
\alias{loo}
\title{Leave-one-out cross-validation (LOO-CV)}
\usage{
loo(variables = "log_lik", r_eff = TRUE, moment_match = FALSE, ...)
}
\arguments{
\item{variables}{(character vector) The name(s) of the variable(s) in the
Stan program containing the pointwise log-likelihood. The default is to
look for \code{"log_lik"}. This argument is passed to the
\code{\link[=fit-method-draws]{$draws()}} method.}

\item{r_eff}{(multiple options) How to handle the \code{r_eff} argument for \code{loo()}:
\itemize{
\item \code{TRUE} (the default) will automatically call \code{\link[loo:relative_eff]{loo::relative_eff.array()}}
to compute the \code{r_eff} argument to pass to \code{\link[loo:loo]{loo::loo.array()}}.
\item \code{FALSE} or \code{NULL} will avoid computing \code{r_eff} (which can sometimes be slow)
but will result in a warning from the \pkg{loo} package.
\item If \code{r_eff} is anything else, that object will be passed as the \code{r_eff}
argument to \code{\link[loo:loo]{loo::loo.array()}}.
}}

\item{moment_match}{(boolean) Whether to use a moment-matching correction for
for problematic observations.}

\item{...}{Other arguments (e.g., \code{cores}, \code{save_psis}, etc.) passed to
\code{\link[loo:loo]{loo::loo.array()}} or \code{\link[loo:loo_moment_match]{loo::loo_moment_match.default()}}
(if \code{moment_match} = \code{TRUE} is set).}
}
\value{
The object returned by \code{\link[loo:loo]{loo::loo.array()}}.
}
\description{
The \verb{$loo()} method computes approximate LOO-CV using the
\pkg{loo} package. This is a simple wrapper around \code{\link[loo:loo]{loo::loo.array()}}
provided for convenience and requires computing the pointwise
log-likelihood in your Stan program. See the \pkg{loo} package
\href{https://mc-stan.org/loo/articles/}{vignettes} for details.
}
\examples{

\dontrun{
# the "logistic" example model has "log_lik" in generated quantities
fit <- cmdstanr_example("logistic")
loo_result <- fit$loo(cores = 2)
print(loo_result)
}

}
\seealso{
The \pkg{loo} package website with
\href{https://mc-stan.org/loo/reference/index.html}{documentation} and
\href{https://mc-stan.org/loo/articles/}{vignettes}.
}
