% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-init}
\alias{fit-method-init}
\alias{init}
\title{Extract user-specified initial values}
\usage{
init()
}
\value{
A list of lists. See \strong{Examples}.
}
\description{
Return user-specified initial values. If the user provided
initial values files or \R objects (list of lists or function) via the
\code{init} argument when fitting the model then these are returned (always in
the list of lists format). Currently it is not possible to extract initial
values generated automatically by CmdStan, although CmdStan may support
this in the future.
}
\examples{
\dontrun{
init_fun <- function() list(alpha = rnorm(1), beta = rnorm(3))
fit <- cmdstanr_example("logistic", init = init_fun, chains = 2)
str(fit$init())

# partial inits (only specifying for a subset of parameters)
init_list <- list(
  list(mu = 10, tau = 2),
  list(mu = -10, tau = 1)
)
fit <- cmdstanr_example("schools_ncp", init = init_list, chains = 2, adapt_delta = 0.9)

# only user-specified inits returned
str(fit$init())
}

}
\seealso{
\code{\link{CmdStanMCMC}}, \code{\link{CmdStanMLE}}, \code{\link{CmdStanVB}}
}
